/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointParams;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointProvider;
import software.amazon.awssdk.services.s3.endpoints.authscheme.S3ExpressEndpointAuthScheme;
import software.amazon.awssdk.services.s3.endpoints.internal.KnownS3ExpressEndpointProperty;
import software.amazon.awssdk.services.s3.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.s3.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.s3.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.s3.endpoints.internal.RuleUrl;
import software.amazon.awssdk.services.s3.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultS3EndpointProvider
implements S3EndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(S3EndpointParams params) {
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.forcePathStyle(), (String)"Parameter 'ForcePathStyle' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.accelerate(), (String)"Parameter 'Accelerate' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useGlobalEndpoint(), (String)"Parameter 'UseGlobalEndpoint' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.disableMultiRegionAccessPoints(), (String)"Parameter 'DisableMultiRegionAccessPoints' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultS3EndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(S3EndpointParams params, String region) {
        RuleResult result = DefaultS3EndpointProvider.endpointRule1(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("A region must be set when sending requests to S3.");
    }

    private static RuleResult endpointRule1(S3EndpointParams params, String region) {
        if (region != null) {
            RulePartition partitionResult;
            if (params.accelerate().booleanValue() && params.useFips().booleanValue()) {
                return RuleResult.error("Accelerate cannot be used with FIPS");
            }
            if (params.useDualStack().booleanValue() && params.endpoint() != null) {
                return RuleResult.error("Cannot set dual-stack in combination with a custom endpoint.");
            }
            if (params.endpoint() != null && params.useFips().booleanValue()) {
                return RuleResult.error("A custom endpoint cannot be combined with FIPS");
            }
            if (params.endpoint() != null && params.accelerate().booleanValue()) {
                return RuleResult.error("A custom endpoint cannot be combined with S3 Accelerate");
            }
            if (params.useFips().booleanValue() && (partitionResult = RulesFunctions.awsPartition(region)) != null && "aws-cn".equals(partitionResult.name())) {
                return RuleResult.error("Partition does not support FIPS");
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule7(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule86(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule158(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule165(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule181(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule352(params, region);
            if (result.isResolved()) {
                return result;
            }
            return DefaultS3EndpointProvider.endpointRule361(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(S3EndpointParams params, String region) {
        String bucketSuffix;
        if (params.bucket() != null && (bucketSuffix = RulesFunctions.substring(params.bucket(), 0, 6, true)) != null && "--x-s3".equals(bucketSuffix)) {
            if (params.accelerate().booleanValue()) {
                return RuleResult.error("S3Express does not support S3 Accelerate.");
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule9(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule23(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule30(params, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("S3Express bucket name is not a valid virtual hostable name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(S3EndpointParams params, String region) {
        RuleUrl url;
        if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule10(params, url, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule17(params, url, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule20(params, url, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("S3Express bucket name is not a valid virtual hostable name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(S3EndpointParams params, RuleUrl url, String region) {
        if (params.disableS3ExpressSessionAuth() != null && params.disableS3ExpressSessionAuth().booleanValue()) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule11(params, url, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule14(params, url, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("S3Express bucket name is not a valid virtual hostable name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(S3EndpointParams params, RuleUrl url, String region) {
        if (url.isIp()) {
            return DefaultS3EndpointProvider.endpointRule12(params, url, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(S3EndpointParams params, RuleUrl url, String region) {
        String uriEncodedBucket = RulesFunctions.uriEncode(params.bucket());
        if (uriEncodedBucket != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + "/" + uriEncodedBucket + url.path())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(S3EndpointParams params, RuleUrl url, String region) {
        if (RulesFunctions.awsIsVirtualHostableS3Bucket(params.bucket(), false)) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + params.bucket() + "." + url.authority() + url.path())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(S3EndpointParams params, RuleUrl url, String region) {
        if (url.isIp()) {
            return DefaultS3EndpointProvider.endpointRule18(params, url, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(S3EndpointParams params, RuleUrl url, String region) {
        String uriEncodedBucket = RulesFunctions.uriEncode(params.bucket());
        if (uriEncodedBucket != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + "/" + uriEncodedBucket + url.path())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(S3EndpointParams params, RuleUrl url, String region) {
        if (RulesFunctions.awsIsVirtualHostableS3Bucket(params.bucket(), false)) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + params.bucket() + "." + url.authority() + url.path())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(S3EndpointParams params, String region) {
        if (params.useS3ExpressControlEndpoint() != null && params.useS3ExpressControlEndpoint().booleanValue()) {
            return DefaultS3EndpointProvider.endpointRule24(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(S3EndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            return DefaultS3EndpointProvider.endpointRule25(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule25(S3EndpointParams params, String region, RulePartition partitionResult) {
        String uriEncodedBucket = RulesFunctions.uriEncode(params.bucket());
        if (uriEncodedBucket != null && params.endpoint() == null) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control-fips.dualstack." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control-fips." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control.dualstack." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(S3EndpointParams params, String region) {
        if (RulesFunctions.awsIsVirtualHostableS3Bucket(params.bucket(), false)) {
            return DefaultS3EndpointProvider.endpointRule31(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule31(S3EndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule32(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule59(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule64(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule69(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule74(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule79(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Unrecognized S3Express bucket name format.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule32(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (params.disableS3ExpressSessionAuth() != null && params.disableS3ExpressSessionAuth().booleanValue()) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule33(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule38(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule43(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule48(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule53(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Unrecognized S3Express bucket name format.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule33(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 6, 14, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 14, 16, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule38(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 6, 15, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 15, 17, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule43(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 6, 19, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 19, 21, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule48(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 6, 20, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 20, 22, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule53(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 6, 26, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 26, 28, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule59(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 6, 14, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 14, 16, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule64(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 6, 15, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 15, 17, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule69(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 6, 19, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 19, 21, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule74(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 6, 20, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 20, 22, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule79(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 6, 26, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 26, 28, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule86(S3EndpointParams params, String region) {
        String accessPointSuffix;
        if (params.bucket() != null && (accessPointSuffix = RulesFunctions.substring(params.bucket(), 0, 7, true)) != null && "--xa-s3".equals(accessPointSuffix)) {
            if (params.accelerate().booleanValue()) {
                return RuleResult.error("S3Express does not support S3 Accelerate.");
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule88(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule102(params, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("S3Express bucket name is not a valid virtual hostable name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule88(S3EndpointParams params, String region) {
        RuleUrl url;
        if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule89(params, url, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule96(params, url, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule99(params, url, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("S3Express bucket name is not a valid virtual hostable name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule89(S3EndpointParams params, RuleUrl url, String region) {
        if (params.disableS3ExpressSessionAuth() != null && params.disableS3ExpressSessionAuth().booleanValue()) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule90(params, url, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule93(params, url, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("S3Express bucket name is not a valid virtual hostable name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule90(S3EndpointParams params, RuleUrl url, String region) {
        if (url.isIp()) {
            return DefaultS3EndpointProvider.endpointRule91(params, url, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule91(S3EndpointParams params, RuleUrl url, String region) {
        String uriEncodedBucket = RulesFunctions.uriEncode(params.bucket());
        if (uriEncodedBucket != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + "/" + uriEncodedBucket + url.path())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule93(S3EndpointParams params, RuleUrl url, String region) {
        if (RulesFunctions.awsIsVirtualHostableS3Bucket(params.bucket(), false)) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + params.bucket() + "." + url.authority() + url.path())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule96(S3EndpointParams params, RuleUrl url, String region) {
        if (url.isIp()) {
            return DefaultS3EndpointProvider.endpointRule97(params, url, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule97(S3EndpointParams params, RuleUrl url, String region) {
        String uriEncodedBucket = RulesFunctions.uriEncode(params.bucket());
        if (uriEncodedBucket != null) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + "/" + uriEncodedBucket + url.path())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule99(S3EndpointParams params, RuleUrl url, String region) {
        if (RulesFunctions.awsIsVirtualHostableS3Bucket(params.bucket(), false)) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + params.bucket() + "." + url.authority() + url.path())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule102(S3EndpointParams params, String region) {
        if (RulesFunctions.awsIsVirtualHostableS3Bucket(params.bucket(), false)) {
            return DefaultS3EndpointProvider.endpointRule103(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule103(S3EndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule104(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule131(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule136(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule141(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule146(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule151(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Unrecognized S3Express bucket name format.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule104(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (params.disableS3ExpressSessionAuth() != null && params.disableS3ExpressSessionAuth().booleanValue()) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule105(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule110(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule115(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule120(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule125(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Unrecognized S3Express bucket name format.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule105(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 7, 15, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 15, 17, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule110(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 7, 16, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 16, 18, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule115(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 7, 20, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 20, 22, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule120(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 7, 21, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 21, 23, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule125(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 7, 27, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 27, 29, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule131(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 7, 15, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 15, 17, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule136(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 7, 16, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 16, 18, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule141(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 7, 20, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 20, 22, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule146(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 7, 21, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 21, 23, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule151(S3EndpointParams params, String region, RulePartition partitionResult) {
        String s3ExpressAvailabilityZoneDelim;
        String s3ExpressAvailabilityZoneId = RulesFunctions.substring(params.bucket(), 7, 27, true);
        if (s3ExpressAvailabilityZoneId != null && (s3ExpressAvailabilityZoneDelim = RulesFunctions.substring(params.bucket(), 27, 29, true)) != null && "--".equals(s3ExpressAvailabilityZoneDelim)) {
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-fips-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + ".dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3express-" + s3ExpressAvailabilityZoneId + "." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(S3ExpressEndpointAuthScheme.builder().disableDoubleEncoding(true).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule158(S3EndpointParams params, String region) {
        if (params.bucket() == null && params.useS3ExpressControlEndpoint() != null && params.useS3ExpressControlEndpoint().booleanValue()) {
            return DefaultS3EndpointProvider.endpointRule159(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule159(S3EndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleUrl url;
            if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.path())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control-fips.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3express-control." + region + "." + partitionResult.dnsSuffix())).putAttribute(KnownS3ExpressEndpointProperty.BACKEND, (Object)"S3Express").putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3express").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule165(S3EndpointParams params, String region) {
        RulePartition regionPartition;
        String outpostId;
        String bucketAliasSuffix;
        String regionPrefix;
        String hardwareType;
        if (params.bucket() != null && (hardwareType = RulesFunctions.substring(params.bucket(), 49, 50, true)) != null && (regionPrefix = RulesFunctions.substring(params.bucket(), 8, 12, true)) != null && (bucketAliasSuffix = RulesFunctions.substring(params.bucket(), 0, 7, true)) != null && (outpostId = RulesFunctions.substring(params.bucket(), 32, 49, true)) != null && (regionPartition = RulesFunctions.awsPartition(region)) != null && "--op-s3".equals(bucketAliasSuffix)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule166(params, outpostId, hardwareType, regionPrefix, region, regionPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule166(S3EndpointParams params, String outpostId, String hardwareType, String regionPrefix, String region, RulePartition regionPartition) {
        if (RulesFunctions.isValidHostLabel(outpostId, false)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule167(params, hardwareType, regionPrefix, region, regionPartition, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid Outposts Bucket alias - it must be a valid bucket name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule167(S3EndpointParams params, String hardwareType, String regionPrefix, String region, RulePartition regionPartition, String outpostId) {
        if (RulesFunctions.awsIsVirtualHostableS3Bucket(params.bucket(), false)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule168(params, hardwareType, regionPrefix, region, regionPartition);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule173(params, hardwareType, regionPrefix, outpostId, region, regionPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Unrecognized hardware type: \"Expected hardware type o or e but got " + hardwareType + "\"");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule168(S3EndpointParams params, String hardwareType, String regionPrefix, String region, RulePartition regionPartition) {
        if ("e".equals(hardwareType)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule169(params, regionPrefix, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".ec2.s3-outposts." + region + "." + regionPartition.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegionSet(Arrays.asList("*")).build(), SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule169(S3EndpointParams params, String regionPrefix, String region) {
        if ("beta".equals(regionPrefix)) {
            RuleUrl url;
            if (params.endpoint() == null) {
                return RuleResult.error("Expected a endpoint to be specified but no endpoint was found");
            }
            if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".ec2." + url.authority())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegionSet(Arrays.asList("*")).build(), SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule173(S3EndpointParams params, String hardwareType, String regionPrefix, String outpostId, String region, RulePartition regionPartition) {
        if ("o".equals(hardwareType)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule174(params, regionPrefix, outpostId, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".op-" + outpostId + ".s3-outposts." + region + "." + regionPartition.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegionSet(Arrays.asList("*")).build(), SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule174(S3EndpointParams params, String regionPrefix, String outpostId, String region) {
        if ("beta".equals(regionPrefix)) {
            RuleUrl url;
            if (params.endpoint() == null) {
                return RuleResult.error("Expected a endpoint to be specified but no endpoint was found");
            }
            if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".op-" + outpostId + "." + url.authority())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegionSet(Arrays.asList("*")).build(), SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule181(S3EndpointParams params, String region) {
        if (params.bucket() != null) {
            if (params.endpoint() != null && RulesFunctions.parseURL(params.endpoint()) == null) {
                return RuleResult.error("Custom endpoint `" + params.endpoint() + "` was not a valid URI");
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule183(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule224(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule229(params, region);
            if (result.isResolved()) {
                return result;
            }
            String arnPrefix = RulesFunctions.substring(params.bucket(), 0, 4, false);
            if (arnPrefix != null && "arn:".equals(arnPrefix) && RulesFunctions.awsParseArn(params.bucket()) == null) {
                return RuleResult.error("Invalid ARN: `" + params.bucket() + "` was not a valid ARN");
            }
            if (params.forcePathStyle().booleanValue() && RulesFunctions.awsParseArn(params.bucket()) != null) {
                return RuleResult.error("Path-style addressing cannot be used with ARN buckets");
            }
            return DefaultS3EndpointProvider.endpointRule326(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule183(S3EndpointParams params, String region) {
        if (!params.forcePathStyle().booleanValue() && RulesFunctions.awsIsVirtualHostableS3Bucket(params.bucket(), false)) {
            return DefaultS3EndpointProvider.endpointRule184(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule184(S3EndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule185(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid region: region was not a valid DNS name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule185(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (RulesFunctions.isValidHostLabel(region, false)) {
            RuleUrl url;
            if (params.accelerate().booleanValue() && "aws-cn".equals(partitionResult.name())) {
                return RuleResult.error("S3 Accelerate cannot be used in this region");
            }
            if (params.useDualStack().booleanValue() && params.useFips().booleanValue() && !params.accelerate().booleanValue() && params.endpoint() == null && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-fips.dualstack.us-east-1." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule188(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            if (params.useDualStack().booleanValue() && params.useFips().booleanValue() && !params.accelerate().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && !params.useGlobalEndpoint().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-fips.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useDualStack().booleanValue() && params.useFips().booleanValue() && !params.accelerate().booleanValue() && params.endpoint() == null && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-fips.us-east-1." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule192(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            if (!(params.useDualStack().booleanValue() || !params.useFips().booleanValue() || params.accelerate().booleanValue() || params.endpoint() != null || "aws-global".equals(region) || params.useGlobalEndpoint().booleanValue())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (params.useDualStack().booleanValue() && !params.useFips().booleanValue() && params.accelerate().booleanValue() && params.endpoint() == null && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-accelerate.dualstack.us-east-1." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule196(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            if (params.useDualStack().booleanValue() && !params.useFips().booleanValue() && params.accelerate().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && !params.useGlobalEndpoint().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-accelerate.dualstack." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (params.useDualStack().booleanValue() && !params.useFips().booleanValue() && !params.accelerate().booleanValue() && params.endpoint() == null && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3.dualstack.us-east-1." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule200(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            if (!(!params.useDualStack().booleanValue() || params.useFips().booleanValue() || params.accelerate().booleanValue() || params.endpoint() != null || "aws-global".equals(region) || params.useGlobalEndpoint().booleanValue())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useDualStack().booleanValue() && !params.useFips().booleanValue() && !params.accelerate().booleanValue() && params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null && url.isIp() && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.normalizedPath() + params.bucket())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            if (!(params.useDualStack().booleanValue() || params.useFips().booleanValue() || params.accelerate().booleanValue() || params.endpoint() == null || (url = RulesFunctions.parseURL(params.endpoint())) == null || url.isIp() || !"aws-global".equals(region))) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + params.bucket() + "." + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule205(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule208(params, region);
            if (result.isResolved()) {
                return result;
            }
            if (!(params.useDualStack().booleanValue() || params.useFips().booleanValue() || params.accelerate().booleanValue() || params.endpoint() == null || (url = RulesFunctions.parseURL(params.endpoint())) == null || !url.isIp() || "aws-global".equals(region) || params.useGlobalEndpoint().booleanValue())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.normalizedPath() + params.bucket())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!(params.useDualStack().booleanValue() || params.useFips().booleanValue() || params.accelerate().booleanValue() || params.endpoint() == null || (url = RulesFunctions.parseURL(params.endpoint())) == null || url.isIp() || "aws-global".equals(region) || params.useGlobalEndpoint().booleanValue())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + params.bucket() + "." + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useDualStack().booleanValue() && !params.useFips().booleanValue() && params.accelerate().booleanValue() && params.endpoint() == null && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-accelerate." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule214(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            if (!(params.useDualStack().booleanValue() || params.useFips().booleanValue() || !params.accelerate().booleanValue() || params.endpoint() != null || "aws-global".equals(region) || params.useGlobalEndpoint().booleanValue())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-accelerate." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useDualStack().booleanValue() && !params.useFips().booleanValue() && !params.accelerate().booleanValue() && params.endpoint() == null && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule219(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            if (!(params.useDualStack().booleanValue() || params.useFips().booleanValue() || params.accelerate().booleanValue() || params.endpoint() != null || "aws-global".equals(region) || params.useGlobalEndpoint().booleanValue())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule188(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (params.useDualStack().booleanValue() && params.useFips().booleanValue() && !params.accelerate().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-fips.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule192(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (!params.useDualStack().booleanValue() && params.useFips().booleanValue() && !params.accelerate().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule196(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (params.useDualStack().booleanValue() && !params.useFips().booleanValue() && params.accelerate().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-accelerate.dualstack." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule200(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (params.useDualStack().booleanValue() && !params.useFips().booleanValue() && !params.accelerate().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule205(S3EndpointParams params, String region) {
        RuleUrl url;
        if (!params.useDualStack().booleanValue() && !params.useFips().booleanValue() && !params.accelerate().booleanValue() && params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null && url.isIp() && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            if ("us-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.normalizedPath() + params.bucket())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.normalizedPath() + params.bucket())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule208(S3EndpointParams params, String region) {
        RuleUrl url;
        if (!(params.useDualStack().booleanValue() || params.useFips().booleanValue() || params.accelerate().booleanValue() || params.endpoint() == null || (url = RulesFunctions.parseURL(params.endpoint())) == null || url.isIp() || "aws-global".equals(region) || !params.useGlobalEndpoint().booleanValue())) {
            if ("us-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + params.bucket() + "." + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + params.bucket() + "." + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule214(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (!params.useDualStack().booleanValue() && !params.useFips().booleanValue() && params.accelerate().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            if ("us-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-accelerate." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3-accelerate." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule219(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (!(params.useDualStack().booleanValue() || params.useFips().booleanValue() || params.accelerate().booleanValue() || params.endpoint() != null || "aws-global".equals(region) || !params.useGlobalEndpoint().booleanValue())) {
            if ("us-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + params.bucket() + ".s3." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule224(S3EndpointParams params, String region) {
        RuleUrl url;
        if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null && "http".equals(url.scheme()) && RulesFunctions.awsIsVirtualHostableS3Bucket(params.bucket(), true) && !params.forcePathStyle().booleanValue() && !params.useFips().booleanValue() && !params.useDualStack().booleanValue() && !params.accelerate().booleanValue()) {
            return DefaultS3EndpointProvider.endpointRule225(params, region, url);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule225(S3EndpointParams params, String region, RuleUrl url) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule226(params, region, url);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid region: region was not a valid DNS name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule226(S3EndpointParams params, String region, RuleUrl url) {
        if (RulesFunctions.isValidHostLabel(region, false)) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + params.bucket() + "." + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule229(S3EndpointParams params, String region) {
        RuleArn bucketArn;
        if (!params.forcePathStyle().booleanValue() && (bucketArn = RulesFunctions.awsParseArn(params.bucket())) != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule230(params, bucketArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: No ARN type specified");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule230(S3EndpointParams params, RuleArn bucketArn, String region) {
        String arnType = RulesFunctions.listAccess(bucketArn.resourceId(), 0);
        if (arnType != null && !"".equals(arnType)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule231(params, bucketArn, arnType, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule258(params, arnType, bucketArn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule296(params, bucketArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Unrecognized format: " + params.bucket() + " (type: " + arnType + ")");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule231(S3EndpointParams params, RuleArn bucketArn, String arnType, String region) {
        if ("s3-object-lambda".equals(bucketArn.service())) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule232(params, arnType, bucketArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Object Lambda ARNs only support `accesspoint` arn types, but found: `" + arnType + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule232(S3EndpointParams params, String arnType, RuleArn bucketArn, String region) {
        if ("accesspoint".equals(arnType)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule233(params, bucketArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule233(S3EndpointParams params, RuleArn bucketArn, String region) {
        String accessPointName = RulesFunctions.listAccess(bucketArn.resourceId(), 1);
        if (accessPointName != null && !"".equals(accessPointName)) {
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("S3 Object Lambda does not support Dual-stack");
            }
            if (params.accelerate().booleanValue()) {
                return RuleResult.error("S3 Object Lambda does not support S3 Accelerate");
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule236(params, bucketArn, region, accessPointName);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: bucket ARN is missing a region");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule236(S3EndpointParams params, RuleArn bucketArn, String region, String accessPointName) {
        if (!"".equals(bucketArn.region())) {
            if (params.disableAccessPoints() != null && params.disableAccessPoints().booleanValue()) {
                return RuleResult.error("Access points are not supported for this operation");
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule238(params, bucketArn, region, accessPointName);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule238(S3EndpointParams params, RuleArn bucketArn, String region, String accessPointName) {
        if (RulesFunctions.listAccess(bucketArn.resourceId(), 2) == null) {
            if (params.useArnRegion() != null && !params.useArnRegion().booleanValue() && !RulesFunctions.stringEquals(bucketArn.region(), region)) {
                return RuleResult.error("Invalid configuration: region from ARN `" + bucketArn.region() + "` does not match client region `" + region + "` and UseArnRegion is `false`");
            }
            return DefaultS3EndpointProvider.endpointRule240(params, bucketArn, region, accessPointName);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule240(S3EndpointParams params, RuleArn bucketArn, String region, String accessPointName) {
        RulePartition bucketPartition = RulesFunctions.awsPartition(bucketArn.region());
        if (bucketPartition != null) {
            return DefaultS3EndpointProvider.endpointRule241(params, region, bucketPartition, bucketArn, accessPointName);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule241(S3EndpointParams params, String region, RulePartition bucketPartition, RuleArn bucketArn, String accessPointName) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule242(params, bucketPartition, partitionResult, bucketArn, accessPointName);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Client was configured for partition `" + partitionResult.name() + "` but ARN (`" + params.bucket() + "`) has `" + bucketPartition.name() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule242(S3EndpointParams params, RulePartition bucketPartition, RulePartition partitionResult, RuleArn bucketArn, String accessPointName) {
        if (RulesFunctions.stringEquals(bucketPartition.name(), partitionResult.name())) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule243(params, bucketArn, accessPointName, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid region in ARN: `" + bucketArn.region() + "` (invalid DNS name)");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule243(S3EndpointParams params, RuleArn bucketArn, String accessPointName, RulePartition bucketPartition) {
        if (RulesFunctions.isValidHostLabel(bucketArn.region(), true)) {
            if ("".equals(bucketArn.accountId())) {
                return RuleResult.error("Invalid ARN: Missing account id");
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule245(params, bucketArn, accessPointName, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `" + bucketArn.accountId() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule245(S3EndpointParams params, RuleArn bucketArn, String accessPointName, RulePartition bucketPartition) {
        if (RulesFunctions.isValidHostLabel(bucketArn.accountId(), false)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule246(params, accessPointName, bucketArn, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `" + accessPointName + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule246(S3EndpointParams params, String accessPointName, RuleArn bucketArn, RulePartition bucketPartition) {
        if (RulesFunctions.isValidHostLabel(accessPointName, false)) {
            RuleUrl url;
            if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + accessPointName + "-" + bucketArn.accountId() + "." + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-object-lambda").signingRegion(bucketArn.region()).build())).build());
            }
            if (params.useFips().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + accessPointName + "-" + bucketArn.accountId() + ".s3-object-lambda-fips." + bucketArn.region() + "." + bucketPartition.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-object-lambda").signingRegion(bucketArn.region()).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + accessPointName + "-" + bucketArn.accountId() + ".s3-object-lambda." + bucketArn.region() + "." + bucketPartition.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-object-lambda").signingRegion(bucketArn.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule258(S3EndpointParams params, String arnType, RuleArn bucketArn, String region) {
        if ("accesspoint".equals(arnType)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule259(params, bucketArn, arnType, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule259(S3EndpointParams params, RuleArn bucketArn, String arnType, String region) {
        String accessPointName = RulesFunctions.listAccess(bucketArn.resourceId(), 1);
        if (accessPointName != null && !"".equals(accessPointName)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule260(params, bucketArn, arnType, region, accessPointName);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultS3EndpointProvider.endpointRule285(params, accessPointName, region, bucketArn);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid Access Point Name");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule260(S3EndpointParams params, RuleArn bucketArn, String arnType, String region, String accessPointName) {
        if (!"".equals(bucketArn.region())) {
            return DefaultS3EndpointProvider.endpointRule261(params, arnType, bucketArn, region, accessPointName);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule261(S3EndpointParams params, String arnType, RuleArn bucketArn, String region, String accessPointName) {
        if ("accesspoint".equals(arnType)) {
            return DefaultS3EndpointProvider.endpointRule262(params, bucketArn, region, accessPointName);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule262(S3EndpointParams params, RuleArn bucketArn, String region, String accessPointName) {
        if (!"".equals(bucketArn.region())) {
            if (params.disableAccessPoints() != null && params.disableAccessPoints().booleanValue()) {
                return RuleResult.error("Access points are not supported for this operation");
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule264(params, bucketArn, region, accessPointName);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule264(S3EndpointParams params, RuleArn bucketArn, String region, String accessPointName) {
        if (RulesFunctions.listAccess(bucketArn.resourceId(), 2) == null) {
            if (params.useArnRegion() != null && !params.useArnRegion().booleanValue() && !RulesFunctions.stringEquals(bucketArn.region(), region)) {
                return RuleResult.error("Invalid configuration: region from ARN `" + bucketArn.region() + "` does not match client region `" + region + "` and UseArnRegion is `false`");
            }
            return DefaultS3EndpointProvider.endpointRule266(params, bucketArn, region, accessPointName);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule266(S3EndpointParams params, RuleArn bucketArn, String region, String accessPointName) {
        RulePartition bucketPartition = RulesFunctions.awsPartition(bucketArn.region());
        if (bucketPartition != null) {
            return DefaultS3EndpointProvider.endpointRule267(params, region, bucketPartition, bucketArn, accessPointName);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule267(S3EndpointParams params, String region, RulePartition bucketPartition, RuleArn bucketArn, String accessPointName) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule268(params, bucketPartition, partitionResult, bucketArn, accessPointName);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Client was configured for partition `" + partitionResult.name() + "` but ARN (`" + params.bucket() + "`) has `" + bucketPartition.name() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule268(S3EndpointParams params, RulePartition bucketPartition, RulePartition partitionResult, RuleArn bucketArn, String accessPointName) {
        if (RulesFunctions.stringEquals(bucketPartition.name(), partitionResult.name())) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule269(params, bucketArn, accessPointName, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid region in ARN: `" + bucketArn.region() + "` (invalid DNS name)");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule269(S3EndpointParams params, RuleArn bucketArn, String accessPointName, RulePartition bucketPartition) {
        if (RulesFunctions.isValidHostLabel(bucketArn.region(), true)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule270(params, bucketArn, accessPointName, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The ARN was not for the S3 service, found: " + bucketArn.service());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule270(S3EndpointParams params, RuleArn bucketArn, String accessPointName, RulePartition bucketPartition) {
        if ("s3".equals(bucketArn.service())) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule271(params, bucketArn, accessPointName, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `" + bucketArn.accountId() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule271(S3EndpointParams params, RuleArn bucketArn, String accessPointName, RulePartition bucketPartition) {
        if (RulesFunctions.isValidHostLabel(bucketArn.accountId(), false)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule272(params, accessPointName, bucketArn, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `" + accessPointName + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule272(S3EndpointParams params, String accessPointName, RuleArn bucketArn, RulePartition bucketPartition) {
        if (RulesFunctions.isValidHostLabel(accessPointName, false)) {
            RuleUrl url;
            if (params.accelerate().booleanValue()) {
                return RuleResult.error("Access Points do not support S3 Accelerate");
            }
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + accessPointName + "-" + bucketArn.accountId() + ".s3-accesspoint-fips.dualstack." + bucketArn.region() + "." + bucketPartition.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(bucketArn.region()).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + accessPointName + "-" + bucketArn.accountId() + ".s3-accesspoint-fips." + bucketArn.region() + "." + bucketPartition.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(bucketArn.region()).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + accessPointName + "-" + bucketArn.accountId() + ".s3-accesspoint.dualstack." + bucketArn.region() + "." + bucketPartition.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(bucketArn.region()).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + accessPointName + "-" + bucketArn.accountId() + "." + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(bucketArn.region()).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + accessPointName + "-" + bucketArn.accountId() + ".s3-accesspoint." + bucketArn.region() + "." + bucketPartition.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(bucketArn.region()).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule285(S3EndpointParams params, String accessPointName, String region, RuleArn bucketArn) {
        if (RulesFunctions.isValidHostLabel(accessPointName, true)) {
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("S3 MRAP does not support dual-stack");
            }
            if (params.useFips().booleanValue()) {
                return RuleResult.error("S3 MRAP does not support FIPS");
            }
            if (params.accelerate().booleanValue()) {
                return RuleResult.error("S3 MRAP does not support S3 Accelerate");
            }
            if (params.disableMultiRegionAccessPoints().booleanValue()) {
                return RuleResult.error("Invalid configuration: Multi-Region Access Point ARNs are disabled.");
            }
            return DefaultS3EndpointProvider.endpointRule290(params, region, bucketArn, accessPointName);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule290(S3EndpointParams params, String region, RuleArn bucketArn, String accessPointName) {
        RulePartition mrapPartition = RulesFunctions.awsPartition(region);
        if (mrapPartition != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule291(params, mrapPartition, bucketArn, accessPointName);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Client was configured for partition `" + mrapPartition.name() + "` but bucket referred to partition `" + bucketArn.partition() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule291(S3EndpointParams params, RulePartition mrapPartition, RuleArn bucketArn, String accessPointName) {
        if (RulesFunctions.stringEquals(mrapPartition.name(), bucketArn.partition())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + accessPointName + ".accesspoint.s3-global." + mrapPartition.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegionSet(Arrays.asList("*")).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule296(S3EndpointParams params, RuleArn bucketArn, String region) {
        if ("s3-outposts".equals(bucketArn.service())) {
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("S3 Outposts does not support Dual-stack");
            }
            if (params.useFips().booleanValue()) {
                return RuleResult.error("S3 Outposts does not support FIPS");
            }
            if (params.accelerate().booleanValue()) {
                return RuleResult.error("S3 Outposts does not support S3 Accelerate");
            }
            if (RulesFunctions.listAccess(bucketArn.resourceId(), 4) != null) {
                return RuleResult.error("Invalid Arn: Outpost Access Point ARN contains sub resources");
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule301(params, bucketArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The Outpost Id was not set");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule301(S3EndpointParams params, RuleArn bucketArn, String region) {
        String outpostId = RulesFunctions.listAccess(bucketArn.resourceId(), 1);
        if (outpostId != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule302(params, outpostId, bucketArn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The outpost Id may only contain a-z, A-Z, 0-9 and `-`. Found: `" + outpostId + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule302(S3EndpointParams params, String outpostId, RuleArn bucketArn, String region) {
        if (RulesFunctions.isValidHostLabel(outpostId, false)) {
            if (params.useArnRegion() != null && !params.useArnRegion().booleanValue() && !RulesFunctions.stringEquals(bucketArn.region(), region)) {
                return RuleResult.error("Invalid configuration: region from ARN `" + bucketArn.region() + "` does not match client region `" + region + "` and UseArnRegion is `false`");
            }
            return DefaultS3EndpointProvider.endpointRule304(params, bucketArn, region, outpostId);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule304(S3EndpointParams params, RuleArn bucketArn, String region, String outpostId) {
        RulePartition bucketPartition = RulesFunctions.awsPartition(bucketArn.region());
        if (bucketPartition != null) {
            return DefaultS3EndpointProvider.endpointRule305(params, region, bucketPartition, bucketArn, outpostId);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule305(S3EndpointParams params, String region, RulePartition bucketPartition, RuleArn bucketArn, String outpostId) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule306(params, bucketPartition, partitionResult, bucketArn, outpostId);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Client was configured for partition `" + partitionResult.name() + "` but ARN (`" + params.bucket() + "`) has `" + bucketPartition.name() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule306(S3EndpointParams params, RulePartition bucketPartition, RulePartition partitionResult, RuleArn bucketArn, String outpostId) {
        if (RulesFunctions.stringEquals(bucketPartition.name(), partitionResult.name())) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule307(params, bucketArn, outpostId, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid region in ARN: `" + bucketArn.region() + "` (invalid DNS name)");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule307(S3EndpointParams params, RuleArn bucketArn, String outpostId, RulePartition bucketPartition) {
        if (RulesFunctions.isValidHostLabel(bucketArn.region(), true)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule308(params, bucketArn, outpostId, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `" + bucketArn.accountId() + "`");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule308(S3EndpointParams params, RuleArn bucketArn, String outpostId, RulePartition bucketPartition) {
        if (RulesFunctions.isValidHostLabel(bucketArn.accountId(), false)) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule309(params, bucketArn, outpostId, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Expected a 4-component resource");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule309(S3EndpointParams params, RuleArn bucketArn, String outpostId, RulePartition bucketPartition) {
        String outpostType = RulesFunctions.listAccess(bucketArn.resourceId(), 2);
        if (outpostType != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule310(params, bucketArn, outpostType, outpostId, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: expected an access point name");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule310(S3EndpointParams params, RuleArn bucketArn, String outpostType, String outpostId, RulePartition bucketPartition) {
        String accessPointName = RulesFunctions.listAccess(bucketArn.resourceId(), 3);
        if (accessPointName != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule311(params, outpostType, accessPointName, bucketArn, outpostId, bucketPartition);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Expected an outpost type `accesspoint`, found " + outpostType);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule311(S3EndpointParams params, String outpostType, String accessPointName, RuleArn bucketArn, String outpostId, RulePartition bucketPartition) {
        if ("accesspoint".equals(outpostType)) {
            RuleUrl url;
            if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + accessPointName + "-" + bucketArn.accountId() + "." + outpostId + "." + url.authority())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegionSet(Arrays.asList("*")).build(), SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(bucketArn.region()).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + accessPointName + "-" + bucketArn.accountId() + "." + outpostId + ".s3-outposts." + bucketArn.region() + "." + bucketPartition.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegionSet(Arrays.asList("*")).build(), SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-outposts").signingRegion(bucketArn.region()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule326(S3EndpointParams params, String region) {
        String uriEncodedBucket = RulesFunctions.uriEncode(params.bucket());
        if (uriEncodedBucket != null) {
            return DefaultS3EndpointProvider.endpointRule327(params, region, uriEncodedBucket);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule327(S3EndpointParams params, String region, String uriEncodedBucket) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule328(params, region, partitionResult, uriEncodedBucket);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Path-style addressing cannot be used with S3 Accelerate");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule328(S3EndpointParams params, String region, RulePartition partitionResult, String uriEncodedBucket) {
        if (!params.accelerate().booleanValue()) {
            RuleUrl url;
            if (params.useDualStack().booleanValue() && params.endpoint() == null && params.useFips().booleanValue() && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips.dualstack.us-east-1." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule330(params, region, partitionResult, uriEncodedBucket);
            if (result.isResolved()) {
                return result;
            }
            if (params.useDualStack().booleanValue() && params.endpoint() == null && params.useFips().booleanValue() && !"aws-global".equals(region) && !params.useGlobalEndpoint().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips.dualstack." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useDualStack().booleanValue() && params.endpoint() == null && params.useFips().booleanValue() && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips.us-east-1." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule334(params, region, partitionResult, uriEncodedBucket);
            if (result.isResolved()) {
                return result;
            }
            if (!params.useDualStack().booleanValue() && params.endpoint() == null && params.useFips().booleanValue() && !"aws-global".equals(region) && !params.useGlobalEndpoint().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (params.useDualStack().booleanValue() && params.endpoint() == null && !params.useFips().booleanValue() && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3.dualstack.us-east-1." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule338(params, region, partitionResult, uriEncodedBucket);
            if (result.isResolved()) {
                return result;
            }
            if (params.useDualStack().booleanValue() && params.endpoint() == null && !params.useFips().booleanValue() && !"aws-global".equals(region) && !params.useGlobalEndpoint().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3.dualstack." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useDualStack().booleanValue() && params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null && !params.useFips().booleanValue() && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.normalizedPath() + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule342(params, region, uriEncodedBucket);
            if (result.isResolved()) {
                return result;
            }
            if (!(params.useDualStack().booleanValue() || params.endpoint() == null || (url = RulesFunctions.parseURL(params.endpoint())) == null || params.useFips().booleanValue() || "aws-global".equals(region) || params.useGlobalEndpoint().booleanValue())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.normalizedPath() + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useDualStack().booleanValue() && params.endpoint() == null && !params.useFips().booleanValue() && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule347(params, region, partitionResult, uriEncodedBucket);
            if (result.isResolved()) {
                return result;
            }
            if (!(params.useDualStack().booleanValue() || params.endpoint() != null || params.useFips().booleanValue() || "aws-global".equals(region) || params.useGlobalEndpoint().booleanValue())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule330(S3EndpointParams params, String region, RulePartition partitionResult, String uriEncodedBucket) {
        if (params.useDualStack().booleanValue() && params.endpoint() == null && params.useFips().booleanValue() && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips.dualstack." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule334(S3EndpointParams params, String region, RulePartition partitionResult, String uriEncodedBucket) {
        if (!params.useDualStack().booleanValue() && params.endpoint() == null && params.useFips().booleanValue() && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule338(S3EndpointParams params, String region, RulePartition partitionResult, String uriEncodedBucket) {
        if (params.useDualStack().booleanValue() && params.endpoint() == null && !params.useFips().booleanValue() && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3.dualstack." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule342(S3EndpointParams params, String region, String uriEncodedBucket) {
        RuleUrl url;
        if (!params.useDualStack().booleanValue() && params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null && !params.useFips().booleanValue() && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            if ("us-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.normalizedPath() + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.normalizedPath() + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule347(S3EndpointParams params, String region, RulePartition partitionResult, String uriEncodedBucket) {
        if (!params.useDualStack().booleanValue() && params.endpoint() == null && !params.useFips().booleanValue() && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            if ("us-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3." + region + "." + partitionResult.dnsSuffix() + "/" + uriEncodedBucket)).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule352(S3EndpointParams params, String region) {
        if (params.useObjectLambdaEndpoint() != null && params.useObjectLambdaEndpoint().booleanValue()) {
            return DefaultS3EndpointProvider.endpointRule353(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule353(S3EndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule354(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid region: region was not a valid DNS name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule354(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (RulesFunctions.isValidHostLabel(region, true)) {
            RuleUrl url;
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("S3 Object Lambda does not support Dual-stack");
            }
            if (params.accelerate().booleanValue()) {
                return RuleResult.error("S3 Object Lambda does not support S3 Accelerate");
            }
            if (params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-object-lambda").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-object-lambda-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-object-lambda").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-object-lambda." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3-object-lambda").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule361(S3EndpointParams params, String region) {
        if (params.bucket() == null) {
            return DefaultS3EndpointProvider.endpointRule362(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule362(S3EndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultS3EndpointProvider.endpointRule363(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid region: region was not a valid DNS name.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule363(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (RulesFunctions.isValidHostLabel(region, true)) {
            RuleUrl url;
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue() && params.endpoint() == null && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips.dualstack.us-east-1." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            RuleResult result = DefaultS3EndpointProvider.endpointRule365(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            if (params.useFips().booleanValue() && params.useDualStack().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && !params.useGlobalEndpoint().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.endpoint() == null && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips.us-east-1." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule369(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            if (params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && !params.useGlobalEndpoint().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue() && params.endpoint() == null && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3.dualstack.us-east-1." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule373(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            if (!params.useFips().booleanValue() && params.useDualStack().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && !params.useGlobalEndpoint().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule377(params, region);
            if (result.isResolved()) {
                return result;
            }
            if (!(params.useFips().booleanValue() || params.useDualStack().booleanValue() || params.endpoint() == null || (url = RulesFunctions.parseURL(params.endpoint())) == null || "aws-global".equals(region) || params.useGlobalEndpoint().booleanValue())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.endpoint() == null && "aws-global".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion("us-east-1").build())).build());
            }
            result = DefaultS3EndpointProvider.endpointRule382(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            if (!(params.useFips().booleanValue() || params.useDualStack().booleanValue() || params.endpoint() != null || "aws-global".equals(region) || params.useGlobalEndpoint().booleanValue())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule365(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule369(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3-fips." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule373(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (!params.useFips().booleanValue() && params.useDualStack().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3.dualstack." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule377(S3EndpointParams params, String region) {
        RuleUrl url;
        if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.endpoint() != null && (url = RulesFunctions.parseURL(params.endpoint())) != null && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            if ("us-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(url.scheme() + "://" + url.authority() + url.path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule382(S3EndpointParams params, String region, RulePartition partitionResult) {
        if (!params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.endpoint() == null && !"aws-global".equals(region) && params.useGlobalEndpoint().booleanValue()) {
            if ("us-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://s3." + region + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().disableDoubleEncoding(Boolean.valueOf(true)).signingName("s3").signingRegion(region).build())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

