/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.io.InputStream;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.StringInputStream;

@SdkInternalApi
public final class GetBucketPolicyInterceptor
implements ExecutionInterceptor {
    public Optional<InputStream> modifyHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        if (context.request() instanceof GetBucketPolicyRequest) {
            String policy = context.responseBody() == null ? null : (String)FunctionalUtils.invokeSafely(() -> IoUtils.toUtf8String((InputStream)((InputStream)context.responseBody().get())));
            String xml = String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Policy><![CDATA[%s]]></Policy>", policy);
            return Optional.of(AbortableInputStream.create((InputStream)new StringInputStream(xml)));
        }
        return context.responseBody();
    }
}

