/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SessionMode {
    READ_ONLY("ReadOnly"),
    READ_WRITE("ReadWrite"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SessionMode> VALUE_MAP;
    private final String value;

    private SessionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SessionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SessionMode> knownValues() {
        EnumSet<SessionMode> knownValues = EnumSet.allOf(SessionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SessionMode.class, SessionMode::toString);
    }
}

