/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the <code>MultipartUpload</code> for the Amazon S3 object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultipartUpload implements SdkPojo, Serializable, ToCopyableBuilder<MultipartUpload.Builder, MultipartUpload> {
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(MultipartUpload::uploadId))
            .setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadId")
                    .unmarshallLocationName("UploadId").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(MultipartUpload::key))
            .setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").unmarshallLocationName("Key")
                    .build()).build();

    private static final SdkField<Instant> INITIATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MultipartUpload::initiated))
            .setter(setter(Builder::initiated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initiated")
                    .unmarshallLocationName("Initiated").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(MultipartUpload::storageClassAsString))
            .setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass")
                    .unmarshallLocationName("StorageClass").build()).build();

    private static final SdkField<Owner> OWNER_FIELD = SdkField
            .<Owner> builder(MarshallingType.SDK_POJO)
            .getter(getter(MultipartUpload::owner))
            .setter(setter(Builder::owner))
            .constructor(Owner::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner")
                    .unmarshallLocationName("Owner").build()).build();

    private static final SdkField<Initiator> INITIATOR_FIELD = SdkField
            .<Initiator> builder(MarshallingType.SDK_POJO)
            .getter(getter(MultipartUpload::initiator))
            .setter(setter(Builder::initiator))
            .constructor(Initiator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initiator")
                    .unmarshallLocationName("Initiator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_ID_FIELD, KEY_FIELD,
            INITIATED_FIELD, STORAGE_CLASS_FIELD, OWNER_FIELD, INITIATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String uploadId;

    private final String key;

    private final Instant initiated;

    private final String storageClass;

    private final Owner owner;

    private final Initiator initiator;

    private MultipartUpload(BuilderImpl builder) {
        this.uploadId = builder.uploadId;
        this.key = builder.key;
        this.initiated = builder.initiated;
        this.storageClass = builder.storageClass;
        this.owner = builder.owner;
        this.initiator = builder.initiator;
    }

    /**
     * <p>
     * Upload ID that identifies the multipart upload.
     * </p>
     * 
     * @return Upload ID that identifies the multipart upload.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * Key of the object for which the multipart upload was initiated.
     * </p>
     * 
     * @return Key of the object for which the multipart upload was initiated.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * Date and time at which the multipart upload was initiated.
     * </p>
     * 
     * @return Date and time at which the multipart upload was initiated.
     */
    public Instant initiated() {
        return initiated;
    }

    /**
     * <p>
     * The class of storage used to store the object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see StorageClass
     */
    public StorageClass storageClass() {
        return StorageClass.fromValue(storageClass);
    }

    /**
     * <p>
     * The class of storage used to store the object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return The class of storage used to store the object.
     * @see StorageClass
     */
    public String storageClassAsString() {
        return storageClass;
    }

    /**
     * <p>
     * Specifies the owner of the object that is part of the multipart upload.
     * </p>
     * 
     * @return Specifies the owner of the object that is part of the multipart upload.
     */
    public Owner owner() {
        return owner;
    }

    /**
     * <p>
     * Identifies who initiated the multipart upload.
     * </p>
     * 
     * @return Identifies who initiated the multipart upload.
     */
    public Initiator initiator() {
        return initiator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(initiated());
        hashCode = 31 * hashCode + Objects.hashCode(storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(initiator());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultipartUpload)) {
            return false;
        }
        MultipartUpload other = (MultipartUpload) obj;
        return Objects.equals(uploadId(), other.uploadId()) && Objects.equals(key(), other.key())
                && Objects.equals(initiated(), other.initiated())
                && Objects.equals(storageClassAsString(), other.storageClassAsString()) && Objects.equals(owner(), other.owner())
                && Objects.equals(initiator(), other.initiator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MultipartUpload").add("UploadId", uploadId()).add("Key", key()).add("Initiated", initiated())
                .add("StorageClass", storageClassAsString()).add("Owner", owner()).add("Initiator", initiator()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Initiated":
            return Optional.ofNullable(clazz.cast(initiated()));
        case "StorageClass":
            return Optional.ofNullable(clazz.cast(storageClassAsString()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Initiator":
            return Optional.ofNullable(clazz.cast(initiator()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultipartUpload, T> g) {
        return obj -> g.apply((MultipartUpload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultipartUpload> {
        /**
         * <p>
         * Upload ID that identifies the multipart upload.
         * </p>
         * 
         * @param uploadId
         *        Upload ID that identifies the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * Key of the object for which the multipart upload was initiated.
         * </p>
         * 
         * @param key
         *        Key of the object for which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Date and time at which the multipart upload was initiated.
         * </p>
         * 
         * @param initiated
         *        Date and time at which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiated(Instant initiated);

        /**
         * <p>
         * The class of storage used to store the object.
         * </p>
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * <p>
         * The class of storage used to store the object.
         * </p>
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(StorageClass storageClass);

        /**
         * <p>
         * Specifies the owner of the object that is part of the multipart upload.
         * </p>
         * 
         * @param owner
         *        Specifies the owner of the object that is part of the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);

        /**
         * <p>
         * Specifies the owner of the object that is part of the multipart upload.
         * </p>
         * This is a convenience that creates an instance of the {@link Owner.Builder} avoiding the need to create one
         * manually via {@link Owner#builder()}.
         *
         * When the {@link Consumer} completes, {@link Owner.Builder#build()} is called immediately and its result is
         * passed to {@link #owner(Owner)}.
         * 
         * @param owner
         *        a consumer that will call methods on {@link Owner.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owner(Owner)
         */
        default Builder owner(Consumer<Owner.Builder> owner) {
            return owner(Owner.builder().applyMutation(owner).build());
        }

        /**
         * <p>
         * Identifies who initiated the multipart upload.
         * </p>
         * 
         * @param initiator
         *        Identifies who initiated the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiator(Initiator initiator);

        /**
         * <p>
         * Identifies who initiated the multipart upload.
         * </p>
         * This is a convenience that creates an instance of the {@link Initiator.Builder} avoiding the need to create
         * one manually via {@link Initiator#builder()}.
         *
         * When the {@link Consumer} completes, {@link Initiator.Builder#build()} is called immediately and its result
         * is passed to {@link #initiator(Initiator)}.
         * 
         * @param initiator
         *        a consumer that will call methods on {@link Initiator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initiator(Initiator)
         */
        default Builder initiator(Consumer<Initiator.Builder> initiator) {
            return initiator(Initiator.builder().applyMutation(initiator).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String uploadId;

        private String key;

        private Instant initiated;

        private String storageClass;

        private Owner owner;

        private Initiator initiator;

        private BuilderImpl() {
        }

        private BuilderImpl(MultipartUpload model) {
            uploadId(model.uploadId);
            key(model.key);
            initiated(model.initiated);
            storageClass(model.storageClass);
            owner(model.owner);
            initiator(model.initiator);
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Instant getInitiated() {
            return initiated;
        }

        @Override
        public final Builder initiated(Instant initiated) {
            this.initiated = initiated;
            return this;
        }

        public final void setInitiated(Instant initiated) {
            this.initiated = initiated;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final Owner.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public final Initiator.Builder getInitiator() {
            return initiator != null ? initiator.toBuilder() : null;
        }

        @Override
        public final Builder initiator(Initiator initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(Initiator.BuilderImpl initiator) {
            this.initiator = initiator != null ? initiator.build() : null;
        }

        @Override
        public MultipartUpload build() {
            return new MultipartUpload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
