/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.checksums;

import java.util.Arrays;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.checksums.SdkChecksum;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpHeaders;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.internal.Base16Lower;

@SdkInternalApi
public final class ChecksumsEnabledValidator {
    public static final ExecutionAttribute<SdkChecksum> CHECKSUM = new ExecutionAttribute("checksum");

    private ChecksumsEnabledValidator() {
    }

    public static boolean getObjectChecksumEnabledPerRequest(SdkRequest request, ExecutionAttributes executionAttributes) {
        return request instanceof GetObjectRequest && ChecksumsEnabledValidator.checksumEnabledPerConfig(executionAttributes);
    }

    public static boolean getObjectChecksumEnabledPerResponse(SdkRequest request, SdkHttpHeaders responseHeaders) {
        return request instanceof GetObjectRequest && ChecksumsEnabledValidator.checksumEnabledPerResponse(responseHeaders);
    }

    public static boolean putObjectChecksumEnabled(SdkRequest request, ClientType expectedClientType, ExecutionAttributes executionAttributes, SdkHttpHeaders sdkHttpHeaders) {
        if (!(request instanceof PutObjectRequest)) {
            return false;
        }
        ClientType actualClientType = (ClientType)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_TYPE);
        if (!expectedClientType.equals((Object)actualClientType)) {
            return false;
        }
        if (sdkHttpHeaders.firstMatchingHeader("x-amz-server-side-encryption-customer-algorithm").isPresent()) {
            return false;
        }
        if (sdkHttpHeaders.firstMatchingHeader("x-amz-server-side-encryption").filter(h -> h.contains(ServerSideEncryption.AWS_KMS.toString())).isPresent()) {
            return false;
        }
        return ChecksumsEnabledValidator.checksumEnabledPerConfig(executionAttributes);
    }

    public static void validatePutObjectChecksum(PutObjectResponse response, ExecutionAttributes executionAttributes) {
        byte[] ssHash;
        String contentMd5;
        byte[] digest;
        SdkChecksum checksum = (SdkChecksum)executionAttributes.getAttribute(CHECKSUM);
        if (response.eTag() != null && !Arrays.equals(digest = BinaryUtils.fromBase64((String)(contentMd5 = BinaryUtils.toBase64((byte[])checksum.getChecksumBytes()))), ssHash = Base16Lower.decode((String)response.eTag().replace("\"", "")))) {
            throw SdkClientException.create((String)String.format("Data read has a different checksum than expected. Was 0x%s, but expected 0x%s", BinaryUtils.toHex((byte[])digest), BinaryUtils.toHex((byte[])ssHash)));
        }
    }

    private static boolean checksumEnabledPerResponse(SdkHttpHeaders responseHeaders) {
        return responseHeaders.firstMatchingHeader("x-amz-transfer-encoding").filter(b -> b.equals("append-md5")).isPresent();
    }

    private static boolean checksumEnabledPerConfig(ExecutionAttributes executionAttributes) {
        S3Configuration serviceConfiguration = (S3Configuration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG);
        return serviceConfiguration == null || serviceConfiguration.checksumValidationEnabled();
    }
}

