/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.checksums.Md5Checksum;
import software.amazon.awssdk.core.checksums.SdkChecksum;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.checksums.ChecksumCalculatingAsyncRequestBody;
import software.amazon.awssdk.services.s3.checksums.ChecksumValidatingPublisher;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.internal.Base16Lower;

@SdkInternalApi
public class AsyncChecksumValidationInterceptor
implements ExecutionInterceptor {
    private static final ExecutionAttribute<SdkChecksum> CHECKSUM = new ExecutionAttribute("checksum");

    public Optional<AsyncRequestBody> modifyAsyncHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        if (context.request() instanceof PutObjectRequest && this.checksumValidationEnabled(executionAttributes)) {
            Md5Checksum checksum = new Md5Checksum();
            executionAttributes.putAttribute(CHECKSUM, (Object)checksum);
            return Optional.of(new ChecksumCalculatingAsyncRequestBody((AsyncRequestBody)context.asyncRequestBody().get(), (SdkChecksum)checksum));
        }
        return context.asyncRequestBody();
    }

    public Optional<Publisher<ByteBuffer>> modifyAsyncHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        if (context.request() instanceof GetObjectRequest && this.checksumValidationEnabled(executionAttributes)) {
            int contentLength = Integer.parseInt(context.httpResponse().firstMatchingHeader("Content-Length").orElse("0"));
            Md5Checksum checksum = new Md5Checksum();
            executionAttributes.putAttribute(CHECKSUM, (Object)checksum);
            return Optional.of(new ChecksumValidatingPublisher((Publisher<ByteBuffer>)((Publisher)context.responsePublisher().get()), (SdkChecksum)checksum, contentLength));
        }
        return context.responsePublisher();
    }

    public void afterUnmarshalling(Context.AfterUnmarshalling context, ExecutionAttributes executionAttributes) {
        boolean checksumValidationEnabled = this.checksumValidationEnabled(executionAttributes);
        if (context.response() instanceof PutObjectResponse && checksumValidationEnabled) {
            this.validatePutObjectChecksum(context.response(), executionAttributes);
        }
    }

    private void validatePutObjectChecksum(SdkResponse sdkResponse, ExecutionAttributes executionAttributes) {
        byte[] ssHash;
        String contentMd5;
        byte[] digest;
        SdkChecksum checksum = (SdkChecksum)executionAttributes.getAttribute(CHECKSUM);
        PutObjectResponse response = (PutObjectResponse)sdkResponse;
        if (response.eTag() != null && !Arrays.equals(digest = BinaryUtils.fromBase64((String)(contentMd5 = BinaryUtils.toBase64((byte[])checksum.getChecksumBytes()))), ssHash = Base16Lower.decode((String)response.eTag().replace("\"", "")))) {
            throw SdkClientException.create((String)"Data read has a different checksum than expected.");
        }
    }

    private boolean checksumValidationEnabled(ExecutionAttributes executionAttributes) {
        ClientType clientType = (ClientType)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_TYPE);
        if (ClientType.ASYNC.equals((Object)clientType)) {
            S3Configuration serviceConfiguration = (S3Configuration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG);
            return serviceConfiguration == null || serviceConfiguration.checksumValidationEnabled();
        }
        return false;
    }
}

