/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.s3.model.ObjectVersionStorageClass;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ObjectVersion
implements ToCopyableBuilder<Builder, ObjectVersion> {
    private final String eTag;
    private final Long size;
    private final String storageClass;
    private final String key;
    private final String versionId;
    private final Boolean isLatest;
    private final Instant lastModified;
    private final Owner owner;

    private ObjectVersion(BuilderImpl builder) {
        this.eTag = builder.eTag;
        this.size = builder.size;
        this.storageClass = builder.storageClass;
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.isLatest = builder.isLatest;
        this.lastModified = builder.lastModified;
        this.owner = builder.owner;
    }

    public String eTag() {
        return this.eTag;
    }

    public Long size() {
        return this.size;
    }

    public ObjectVersionStorageClass storageClass() {
        return ObjectVersionStorageClass.fromValue(this.storageClass);
    }

    public String storageClassString() {
        return this.storageClass;
    }

    public String key() {
        return this.key;
    }

    public String versionId() {
        return this.versionId;
    }

    public Boolean isLatest() {
        return this.isLatest;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public Owner owner() {
        return this.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLatest());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectVersion)) {
            return false;
        }
        ObjectVersion other = (ObjectVersion)obj;
        return Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.storageClassString(), other.storageClassString()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.isLatest(), other.isLatest()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.owner(), other.owner());
    }

    public String toString() {
        return ToString.builder((String)"ObjectVersion").add("ETag", (Object)this.eTag()).add("Size", (Object)this.size()).add("StorageClass", (Object)this.storageClassString()).add("Key", (Object)this.key()).add("VersionId", (Object)this.versionId()).add("IsLatest", (Object)this.isLatest()).add("LastModified", (Object)this.lastModified()).add("Owner", (Object)this.owner()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ETag": {
                return Optional.of(clazz.cast(this.eTag()));
            }
            case "Size": {
                return Optional.of(clazz.cast(this.size()));
            }
            case "StorageClass": {
                return Optional.of(clazz.cast(this.storageClassString()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
            case "IsLatest": {
                return Optional.of(clazz.cast(this.isLatest()));
            }
            case "LastModified": {
                return Optional.of(clazz.cast(this.lastModified()));
            }
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String eTag;
        private Long size;
        private String storageClass;
        private String key;
        private String versionId;
        private Boolean isLatest;
        private Instant lastModified;
        private Owner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectVersion model) {
            this.eTag(model.eTag);
            this.size(model.size);
            this.storageClass(model.storageClass);
            this.key(model.key);
            this.versionId(model.versionId);
            this.isLatest(model.isLatest);
            this.lastModified(model.lastModified);
            this.owner(model.owner);
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(ObjectVersionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsLatest() {
            return this.isLatest;
        }

        @Override
        public final Builder isLatest(Boolean isLatest) {
            this.isLatest = isLatest;
            return this;
        }

        public final void setIsLatest(Boolean isLatest) {
            this.isLatest = isLatest;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Owner.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public ObjectVersion build() {
            return new ObjectVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ObjectVersion> {
        public Builder eTag(String var1);

        public Builder size(Long var1);

        public Builder storageClass(String var1);

        public Builder storageClass(ObjectVersionStorageClass var1);

        public Builder key(String var1);

        public Builder versionId(String var1);

        public Builder isLatest(Boolean var1);

        public Builder lastModified(Instant var1);

        public Builder owner(Owner var1);

        default public Builder owner(Consumer<Owner.Builder> owner) {
            return this.owner((Owner)((Owner.Builder)Owner.builder().apply(owner)).build());
        }
    }
}

