/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CORSRule;

public class CORSRuleUnmarshaller
implements Unmarshaller<CORSRule, StaxUnmarshallerContext> {
    private static final CORSRuleUnmarshaller INSTANCE = new CORSRuleUnmarshaller();

    public CORSRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        CORSRule.Builder corsRule;
        block12: {
            corsRule = CORSRule.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> allowedHeaders = null;
            ArrayList<String> allowedMethods = null;
            ArrayList<String> allowedOrigins = null;
            ArrayList<String> exposeHeaders = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    corsRule.allowedHeaders(allowedHeaders);
                    corsRule.allowedMethods(allowedMethods);
                    corsRule.allowedOrigins(allowedOrigins);
                    corsRule.exposeHeaders(exposeHeaders);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("AllowedHeader", targetDepth)) {
                        if (allowedHeaders == null) {
                            allowedHeaders = new ArrayList<String>();
                        }
                        allowedHeaders.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AllowedMethod", targetDepth)) {
                        if (allowedMethods == null) {
                            allowedMethods = new ArrayList<String>();
                        }
                        allowedMethods.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AllowedOrigin", targetDepth)) {
                        if (allowedOrigins == null) {
                            allowedOrigins = new ArrayList<String>();
                        }
                        allowedOrigins.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ExposeHeader", targetDepth)) {
                        if (exposeHeaders == null) {
                            exposeHeaders = new ArrayList<String>();
                        }
                        exposeHeaders.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("MaxAgeSeconds", targetDepth)) continue;
                    corsRule.maxAgeSeconds(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            corsRule.allowedHeaders(allowedHeaders);
            corsRule.allowedMethods(allowedMethods);
            corsRule.allowedOrigins(allowedOrigins);
            corsRule.exposeHeaders(exposeHeaders);
        }
        return (CORSRule)corsRule.build();
    }

    public static CORSRuleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

