/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.s3.model.Event;
import software.amazon.awssdk.services.s3.model.EventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TopicConfigurationDeprecated
implements ToCopyableBuilder<Builder, TopicConfigurationDeprecated> {
    private final String id;
    private final List<String> events;
    private final String event;
    private final String topic;

    private TopicConfigurationDeprecated(BuilderImpl builder) {
        this.id = builder.id;
        this.events = builder.events;
        this.event = builder.event;
        this.topic = builder.topic;
    }

    public String id() {
        return this.id;
    }

    public List<Event> events() {
        return TypeConverter.convert(this.events, Event::fromValue);
    }

    public List<String> eventsStrings() {
        return this.events;
    }

    public Event event() {
        return Event.fromValue(this.event);
    }

    public String eventString() {
        return this.event;
    }

    public String topic() {
        return this.topic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventString());
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConfigurationDeprecated)) {
            return false;
        }
        TopicConfigurationDeprecated other = (TopicConfigurationDeprecated)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.eventsStrings(), other.eventsStrings()) && Objects.equals(this.eventString(), other.eventString()) && Objects.equals(this.topic(), other.topic());
    }

    public String toString() {
        return ToString.builder((String)"TopicConfigurationDeprecated").add("Id", (Object)this.id()).add("Events", this.eventsStrings()).add("Event", (Object)this.eventString()).add("Topic", (Object)this.topic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Events": {
                return Optional.of(clazz.cast(this.eventsStrings()));
            }
            case "Event": {
                return Optional.of(clazz.cast(this.eventString()));
            }
            case "Topic": {
                return Optional.of(clazz.cast(this.topic()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> events;
        private String event;
        private String topic;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicConfigurationDeprecated model) {
            this.id(model.id);
            this.events(model.events);
            this.event(model.event);
            this.topic(model.topic);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        public final String getEvent() {
            return this.event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final String getTopic() {
            return this.topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public TopicConfigurationDeprecated build() {
            return new TopicConfigurationDeprecated(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TopicConfigurationDeprecated> {
        public Builder id(String var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);

        public Builder event(String var1);

        public Builder event(Event var1);

        public Builder topic(String var1);
    }
}

