/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.Rule;
import software.amazon.awssdk.services.s3.model.RulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LifecycleConfiguration
implements ToCopyableBuilder<Builder, LifecycleConfiguration> {
    private final List<Rule> rules;

    private LifecycleConfiguration(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleConfiguration)) {
            return false;
        }
        LifecycleConfiguration other = (LifecycleConfiguration)obj;
        return Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"LifecycleConfiguration").add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Rule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleConfiguration model) {
            this.rules(model.rules);
        }

        public final Collection<Rule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(Rule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        public LifecycleConfiguration build() {
            return new LifecycleConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LifecycleConfiguration> {
        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);
    }
}

