/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.DeleteMarkerEntry;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ObjectVersion;

public final class ListObjectVersionsPaginator
implements SdkIterable<ListObjectVersionsResponse> {
    private final S3Client client;
    private final ListObjectVersionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListObjectVersionsPaginator(S3Client client, ListObjectVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectVersionsResponseFetcher();
    }

    public Iterator<ListObjectVersionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ObjectVersion> versions() {
        Function<ListObjectVersionsResponse, Iterator> getIterator = response -> response != null ? response.versions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public SdkIterable<DeleteMarkerEntry> deleteMarkers() {
        Function<ListObjectVersionsResponse, Iterator> getIterator = response -> response != null ? response.deleteMarkers().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public SdkIterable<CommonPrefix> commonPrefixes() {
        Function<ListObjectVersionsResponse, Iterator> getIterator = response -> response != null ? response.commonPrefixes().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListObjectVersionsResponseFetcher
    implements NextPageFetcher<ListObjectVersionsResponse> {
        private ListObjectVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectVersionsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListObjectVersionsResponse nextPage(ListObjectVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListObjectVersionsPaginator.this.client.listObjectVersions(ListObjectVersionsPaginator.this.firstRequest);
            }
            return ListObjectVersionsPaginator.this.client.listObjectVersions((ListObjectVersionsRequest)((Object)ListObjectVersionsPaginator.this.firstRequest.toBuilder().keyMarker(previousPage.nextKeyMarker()).versionIdMarker(previousPage.nextVersionIdMarker()).build()));
        }
    }
}

