/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.s3.model.CopyPartResult;
import software.amazon.awssdk.services.s3.model.RequestCharged;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadPartCopyResponse
extends S3Response
implements ToCopyableBuilder<Builder, UploadPartCopyResponse> {
    private final String copySourceVersionId;
    private final CopyPartResult copyPartResult;
    private final String serverSideEncryption;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKeyMD5;
    private final String ssekmsKeyId;
    private final String requestCharged;

    private UploadPartCopyResponse(BuilderImpl builder) {
        super(builder);
        this.copySourceVersionId = builder.copySourceVersionId;
        this.copyPartResult = builder.copyPartResult;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.ssekmsKeyId = builder.ssekmsKeyId;
        this.requestCharged = builder.requestCharged;
    }

    public String copySourceVersionId() {
        return this.copySourceVersionId;
    }

    public CopyPartResult copyPartResult() {
        return this.copyPartResult;
    }

    public ServerSideEncryption serverSideEncryption() {
        return ServerSideEncryption.fromValue(this.serverSideEncryption);
    }

    public String serverSideEncryptionString() {
        return this.serverSideEncryption;
    }

    public String sseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String sseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public String ssekmsKeyId() {
        return this.ssekmsKeyId;
    }

    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(this.requestCharged);
    }

    public String requestChargedString() {
        return this.requestCharged;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyPartResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerKeyMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssekmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestChargedString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadPartCopyResponse)) {
            return false;
        }
        UploadPartCopyResponse other = (UploadPartCopyResponse)((Object)obj);
        return Objects.equals(this.copySourceVersionId(), other.copySourceVersionId()) && Objects.equals(this.copyPartResult(), other.copyPartResult()) && Objects.equals(this.serverSideEncryptionString(), other.serverSideEncryptionString()) && Objects.equals(this.sseCustomerAlgorithm(), other.sseCustomerAlgorithm()) && Objects.equals(this.sseCustomerKeyMD5(), other.sseCustomerKeyMD5()) && Objects.equals(this.ssekmsKeyId(), other.ssekmsKeyId()) && Objects.equals(this.requestChargedString(), other.requestChargedString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.copySourceVersionId() != null) {
            sb.append("CopySourceVersionId: ").append(this.copySourceVersionId()).append(",");
        }
        if (this.copyPartResult() != null) {
            sb.append("CopyPartResult: ").append(this.copyPartResult()).append(",");
        }
        if (this.serverSideEncryptionString() != null) {
            sb.append("ServerSideEncryption: ").append(this.serverSideEncryptionString()).append(",");
        }
        if (this.sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(this.sseCustomerAlgorithm()).append(",");
        }
        if (this.sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(this.sseCustomerKeyMD5()).append(",");
        }
        if (this.ssekmsKeyId() != null) {
            sb.append("SSEKMSKeyId: ").append(this.ssekmsKeyId()).append(",");
        }
        if (this.requestChargedString() != null) {
            sb.append("RequestCharged: ").append(this.requestChargedString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CopySourceVersionId": {
                return Optional.of(clazz.cast(this.copySourceVersionId()));
            }
            case "CopyPartResult": {
                return Optional.of(clazz.cast(this.copyPartResult()));
            }
            case "ServerSideEncryption": {
                return Optional.of(clazz.cast(this.serverSideEncryptionString()));
            }
            case "SSECustomerAlgorithm": {
                return Optional.of(clazz.cast(this.sseCustomerAlgorithm()));
            }
            case "SSECustomerKeyMD5": {
                return Optional.of(clazz.cast(this.sseCustomerKeyMD5()));
            }
            case "SSEKMSKeyId": {
                return Optional.of(clazz.cast(this.ssekmsKeyId()));
            }
            case "RequestCharged": {
                return Optional.of(clazz.cast(this.requestChargedString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private String copySourceVersionId;
        private CopyPartResult copyPartResult;
        private String serverSideEncryption;
        private String sseCustomerAlgorithm;
        private String sseCustomerKeyMD5;
        private String ssekmsKeyId;
        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadPartCopyResponse model) {
            this.copySourceVersionId(model.copySourceVersionId);
            this.copyPartResult(model.copyPartResult);
            this.serverSideEncryption(model.serverSideEncryption);
            this.sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            this.sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            this.ssekmsKeyId(model.ssekmsKeyId);
            this.requestCharged(model.requestCharged);
        }

        public final String getCopySourceVersionId() {
            return this.copySourceVersionId;
        }

        @Override
        public final Builder copySourceVersionId(String copySourceVersionId) {
            this.copySourceVersionId = copySourceVersionId;
            return this;
        }

        public final void setCopySourceVersionId(String copySourceVersionId) {
            this.copySourceVersionId = copySourceVersionId;
        }

        public final CopyPartResult.Builder getCopyPartResult() {
            return this.copyPartResult != null ? this.copyPartResult.toBuilder() : null;
        }

        @Override
        public final Builder copyPartResult(CopyPartResult copyPartResult) {
            this.copyPartResult = copyPartResult;
            return this;
        }

        public final void setCopyPartResult(CopyPartResult.BuilderImpl copyPartResult) {
            this.copyPartResult = copyPartResult != null ? copyPartResult.build() : null;
        }

        public final String getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final String getSSECustomerAlgorithm() {
            return this.sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKeyMD5() {
            return this.sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getSSEKMSKeyId() {
            return this.ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSSEKMSKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        public final String getRequestCharged() {
            return this.requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        @Override
        public UploadPartCopyResponse build() {
            return new UploadPartCopyResponse(this);
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    CopyableBuilder<Builder, UploadPartCopyResponse> {
        public Builder copySourceVersionId(String var1);

        public Builder copyPartResult(CopyPartResult var1);

        default public Builder copyPartResult(Consumer<CopyPartResult.Builder> copyPartResult) {
            return this.copyPartResult((CopyPartResult)((CopyPartResult.Builder)CopyPartResult.builder().apply(copyPartResult)).build());
        }

        public Builder serverSideEncryption(String var1);

        public Builder serverSideEncryption(ServerSideEncryption var1);

        public Builder sseCustomerAlgorithm(String var1);

        public Builder sseCustomerKeyMD5(String var1);

        public Builder ssekmsKeyId(String var1);

        public Builder requestCharged(String var1);

        public Builder requestCharged(RequestCharged var1);
    }
}

