/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadPartCopyRequest
extends S3Request
implements ToCopyableBuilder<Builder, UploadPartCopyRequest> {
    private final String bucket;
    private final String copySource;
    private final String copySourceIfMatch;
    private final Instant copySourceIfModifiedSince;
    private final String copySourceIfNoneMatch;
    private final Instant copySourceIfUnmodifiedSince;
    private final String copySourceRange;
    private final String key;
    private final Integer partNumber;
    private final String uploadId;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKey;
    private final String sseCustomerKeyMD5;
    private final String copySourceSSECustomerAlgorithm;
    private final String copySourceSSECustomerKey;
    private final String copySourceSSECustomerKeyMD5;
    private final String requestPayer;

    private UploadPartCopyRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.copySource = builder.copySource;
        this.copySourceIfMatch = builder.copySourceIfMatch;
        this.copySourceIfModifiedSince = builder.copySourceIfModifiedSince;
        this.copySourceIfNoneMatch = builder.copySourceIfNoneMatch;
        this.copySourceIfUnmodifiedSince = builder.copySourceIfUnmodifiedSince;
        this.copySourceRange = builder.copySourceRange;
        this.key = builder.key;
        this.partNumber = builder.partNumber;
        this.uploadId = builder.uploadId;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.copySourceSSECustomerAlgorithm = builder.copySourceSSECustomerAlgorithm;
        this.copySourceSSECustomerKey = builder.copySourceSSECustomerKey;
        this.copySourceSSECustomerKeyMD5 = builder.copySourceSSECustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
    }

    public String bucket() {
        return this.bucket;
    }

    public String copySource() {
        return this.copySource;
    }

    public String copySourceIfMatch() {
        return this.copySourceIfMatch;
    }

    public Instant copySourceIfModifiedSince() {
        return this.copySourceIfModifiedSince;
    }

    public String copySourceIfNoneMatch() {
        return this.copySourceIfNoneMatch;
    }

    public Instant copySourceIfUnmodifiedSince() {
        return this.copySourceIfUnmodifiedSince;
    }

    public String copySourceRange() {
        return this.copySourceRange;
    }

    public String key() {
        return this.key;
    }

    public Integer partNumber() {
        return this.partNumber;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String sseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String sseCustomerKey() {
        return this.sseCustomerKey;
    }

    public String sseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public String copySourceSSECustomerAlgorithm() {
        return this.copySourceSSECustomerAlgorithm;
    }

    public String copySourceSSECustomerKey() {
        return this.copySourceSSECustomerKey;
    }

    public String copySourceSSECustomerKeyMD5() {
        return this.copySourceSSECustomerKeyMD5;
    }

    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(this.requestPayer);
    }

    public String requestPayerString() {
        return this.requestPayer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySource());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceIfMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceIfModifiedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceIfNoneMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceIfUnmodifiedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.partNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerKeyMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceSSECustomerAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceSSECustomerKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.copySourceSSECustomerKeyMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestPayerString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadPartCopyRequest)) {
            return false;
        }
        UploadPartCopyRequest other = (UploadPartCopyRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.copySource(), other.copySource()) && Objects.equals(this.copySourceIfMatch(), other.copySourceIfMatch()) && Objects.equals(this.copySourceIfModifiedSince(), other.copySourceIfModifiedSince()) && Objects.equals(this.copySourceIfNoneMatch(), other.copySourceIfNoneMatch()) && Objects.equals(this.copySourceIfUnmodifiedSince(), other.copySourceIfUnmodifiedSince()) && Objects.equals(this.copySourceRange(), other.copySourceRange()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.partNumber(), other.partNumber()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.sseCustomerAlgorithm(), other.sseCustomerAlgorithm()) && Objects.equals(this.sseCustomerKey(), other.sseCustomerKey()) && Objects.equals(this.sseCustomerKeyMD5(), other.sseCustomerKeyMD5()) && Objects.equals(this.copySourceSSECustomerAlgorithm(), other.copySourceSSECustomerAlgorithm()) && Objects.equals(this.copySourceSSECustomerKey(), other.copySourceSSECustomerKey()) && Objects.equals(this.copySourceSSECustomerKeyMD5(), other.copySourceSSECustomerKeyMD5()) && Objects.equals(this.requestPayerString(), other.requestPayerString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.copySource() != null) {
            sb.append("CopySource: ").append(this.copySource()).append(",");
        }
        if (this.copySourceIfMatch() != null) {
            sb.append("CopySourceIfMatch: ").append(this.copySourceIfMatch()).append(",");
        }
        if (this.copySourceIfModifiedSince() != null) {
            sb.append("CopySourceIfModifiedSince: ").append(this.copySourceIfModifiedSince()).append(",");
        }
        if (this.copySourceIfNoneMatch() != null) {
            sb.append("CopySourceIfNoneMatch: ").append(this.copySourceIfNoneMatch()).append(",");
        }
        if (this.copySourceIfUnmodifiedSince() != null) {
            sb.append("CopySourceIfUnmodifiedSince: ").append(this.copySourceIfUnmodifiedSince()).append(",");
        }
        if (this.copySourceRange() != null) {
            sb.append("CopySourceRange: ").append(this.copySourceRange()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.partNumber() != null) {
            sb.append("PartNumber: ").append(this.partNumber()).append(",");
        }
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (this.sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(this.sseCustomerAlgorithm()).append(",");
        }
        if (this.sseCustomerKey() != null) {
            sb.append("SSECustomerKey: ").append(this.sseCustomerKey()).append(",");
        }
        if (this.sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(this.sseCustomerKeyMD5()).append(",");
        }
        if (this.copySourceSSECustomerAlgorithm() != null) {
            sb.append("CopySourceSSECustomerAlgorithm: ").append(this.copySourceSSECustomerAlgorithm()).append(",");
        }
        if (this.copySourceSSECustomerKey() != null) {
            sb.append("CopySourceSSECustomerKey: ").append(this.copySourceSSECustomerKey()).append(",");
        }
        if (this.copySourceSSECustomerKeyMD5() != null) {
            sb.append("CopySourceSSECustomerKeyMD5: ").append(this.copySourceSSECustomerKeyMD5()).append(",");
        }
        if (this.requestPayerString() != null) {
            sb.append("RequestPayer: ").append(this.requestPayerString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "CopySource": {
                return Optional.of(clazz.cast(this.copySource()));
            }
            case "CopySourceIfMatch": {
                return Optional.of(clazz.cast(this.copySourceIfMatch()));
            }
            case "CopySourceIfModifiedSince": {
                return Optional.of(clazz.cast(this.copySourceIfModifiedSince()));
            }
            case "CopySourceIfNoneMatch": {
                return Optional.of(clazz.cast(this.copySourceIfNoneMatch()));
            }
            case "CopySourceIfUnmodifiedSince": {
                return Optional.of(clazz.cast(this.copySourceIfUnmodifiedSince()));
            }
            case "CopySourceRange": {
                return Optional.of(clazz.cast(this.copySourceRange()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "PartNumber": {
                return Optional.of(clazz.cast(this.partNumber()));
            }
            case "UploadId": {
                return Optional.of(clazz.cast(this.uploadId()));
            }
            case "SSECustomerAlgorithm": {
                return Optional.of(clazz.cast(this.sseCustomerAlgorithm()));
            }
            case "SSECustomerKey": {
                return Optional.of(clazz.cast(this.sseCustomerKey()));
            }
            case "SSECustomerKeyMD5": {
                return Optional.of(clazz.cast(this.sseCustomerKeyMD5()));
            }
            case "CopySourceSSECustomerAlgorithm": {
                return Optional.of(clazz.cast(this.copySourceSSECustomerAlgorithm()));
            }
            case "CopySourceSSECustomerKey": {
                return Optional.of(clazz.cast(this.copySourceSSECustomerKey()));
            }
            case "CopySourceSSECustomerKeyMD5": {
                return Optional.of(clazz.cast(this.copySourceSSECustomerKeyMD5()));
            }
            case "RequestPayer": {
                return Optional.of(clazz.cast(this.requestPayerString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private String copySource;
        private String copySourceIfMatch;
        private Instant copySourceIfModifiedSince;
        private String copySourceIfNoneMatch;
        private Instant copySourceIfUnmodifiedSince;
        private String copySourceRange;
        private String key;
        private Integer partNumber;
        private String uploadId;
        private String sseCustomerAlgorithm;
        private String sseCustomerKey;
        private String sseCustomerKeyMD5;
        private String copySourceSSECustomerAlgorithm;
        private String copySourceSSECustomerKey;
        private String copySourceSSECustomerKeyMD5;
        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadPartCopyRequest model) {
            this.bucket(model.bucket);
            this.copySource(model.copySource);
            this.copySourceIfMatch(model.copySourceIfMatch);
            this.copySourceIfModifiedSince(model.copySourceIfModifiedSince);
            this.copySourceIfNoneMatch(model.copySourceIfNoneMatch);
            this.copySourceIfUnmodifiedSince(model.copySourceIfUnmodifiedSince);
            this.copySourceRange(model.copySourceRange);
            this.key(model.key);
            this.partNumber(model.partNumber);
            this.uploadId(model.uploadId);
            this.sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            this.sseCustomerKey(model.sseCustomerKey);
            this.sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            this.copySourceSSECustomerAlgorithm(model.copySourceSSECustomerAlgorithm);
            this.copySourceSSECustomerKey(model.copySourceSSECustomerKey);
            this.copySourceSSECustomerKeyMD5(model.copySourceSSECustomerKeyMD5);
            this.requestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getCopySource() {
            return this.copySource;
        }

        @Override
        public final Builder copySource(String copySource) {
            this.copySource = copySource;
            return this;
        }

        public final void setCopySource(String copySource) {
            this.copySource = copySource;
        }

        public final String getCopySourceIfMatch() {
            return this.copySourceIfMatch;
        }

        @Override
        public final Builder copySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
            return this;
        }

        public final void setCopySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
        }

        public final Instant getCopySourceIfModifiedSince() {
            return this.copySourceIfModifiedSince;
        }

        @Override
        public final Builder copySourceIfModifiedSince(Instant copySourceIfModifiedSince) {
            this.copySourceIfModifiedSince = copySourceIfModifiedSince;
            return this;
        }

        public final void setCopySourceIfModifiedSince(Instant copySourceIfModifiedSince) {
            this.copySourceIfModifiedSince = copySourceIfModifiedSince;
        }

        public final String getCopySourceIfNoneMatch() {
            return this.copySourceIfNoneMatch;
        }

        @Override
        public final Builder copySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
            return this;
        }

        public final void setCopySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
        }

        public final Instant getCopySourceIfUnmodifiedSince() {
            return this.copySourceIfUnmodifiedSince;
        }

        @Override
        public final Builder copySourceIfUnmodifiedSince(Instant copySourceIfUnmodifiedSince) {
            this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
            return this;
        }

        public final void setCopySourceIfUnmodifiedSince(Instant copySourceIfUnmodifiedSince) {
            this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
        }

        public final String getCopySourceRange() {
            return this.copySourceRange;
        }

        @Override
        public final Builder copySourceRange(String copySourceRange) {
            this.copySourceRange = copySourceRange;
            return this;
        }

        public final void setCopySourceRange(String copySourceRange) {
            this.copySourceRange = copySourceRange;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getSSECustomerAlgorithm() {
            return this.sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKey() {
            return this.sseCustomerKey;
        }

        @Override
        public final Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public final void setSSECustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
        }

        public final String getSSECustomerKeyMD5() {
            return this.sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getCopySourceSSECustomerAlgorithm() {
            return this.copySourceSSECustomerAlgorithm;
        }

        @Override
        public final Builder copySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm) {
            this.copySourceSSECustomerAlgorithm = copySourceSSECustomerAlgorithm;
            return this;
        }

        public final void setCopySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm) {
            this.copySourceSSECustomerAlgorithm = copySourceSSECustomerAlgorithm;
        }

        public final String getCopySourceSSECustomerKey() {
            return this.copySourceSSECustomerKey;
        }

        @Override
        public final Builder copySourceSSECustomerKey(String copySourceSSECustomerKey) {
            this.copySourceSSECustomerKey = copySourceSSECustomerKey;
            return this;
        }

        public final void setCopySourceSSECustomerKey(String copySourceSSECustomerKey) {
            this.copySourceSSECustomerKey = copySourceSSECustomerKey;
        }

        public final String getCopySourceSSECustomerKeyMD5() {
            return this.copySourceSSECustomerKeyMD5;
        }

        @Override
        public final Builder copySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5) {
            this.copySourceSSECustomerKeyMD5 = copySourceSSECustomerKeyMD5;
            return this;
        }

        public final void setCopySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5) {
            this.copySourceSSECustomerKeyMD5 = copySourceSSECustomerKeyMD5;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UploadPartCopyRequest build() {
            return new UploadPartCopyRequest(this);
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    CopyableBuilder<Builder, UploadPartCopyRequest> {
        public Builder bucket(String var1);

        public Builder copySource(String var1);

        public Builder copySourceIfMatch(String var1);

        public Builder copySourceIfModifiedSince(Instant var1);

        public Builder copySourceIfNoneMatch(String var1);

        public Builder copySourceIfUnmodifiedSince(Instant var1);

        public Builder copySourceRange(String var1);

        public Builder key(String var1);

        public Builder partNumber(Integer var1);

        public Builder uploadId(String var1);

        public Builder sseCustomerAlgorithm(String var1);

        public Builder sseCustomerKey(String var1);

        public Builder sseCustomerKeyMD5(String var1);

        public Builder copySourceSSECustomerAlgorithm(String var1);

        public Builder copySourceSSECustomerKey(String var1);

        public Builder copySourceSSECustomerKeyMD5(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

