/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.FilterRule;
import software.amazon.awssdk.services.s3.model.FilterRuleListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3KeyFilter
implements ToCopyableBuilder<Builder, S3KeyFilter> {
    private final List<FilterRule> filterRules;

    private S3KeyFilter(BuilderImpl builder) {
        this.filterRules = builder.filterRules;
    }

    public List<FilterRule> filterRules() {
        return this.filterRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3KeyFilter)) {
            return false;
        }
        S3KeyFilter other = (S3KeyFilter)obj;
        return Objects.equals(this.filterRules(), other.filterRules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filterRules() != null) {
            sb.append("FilterRules: ").append(this.filterRules()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterRules": {
                return Optional.of(clazz.cast(this.filterRules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<FilterRule> filterRules;

        private BuilderImpl() {
        }

        private BuilderImpl(S3KeyFilter model) {
            this.filterRules(model.filterRules);
        }

        public final Collection<FilterRule.Builder> getFilterRules() {
            return this.filterRules != null ? (Collection)this.filterRules.stream().map(FilterRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filterRules(Collection<FilterRule> filterRules) {
            this.filterRules = FilterRuleListCopier.copy(filterRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterRules(FilterRule ... filterRules) {
            this.filterRules(Arrays.asList(filterRules));
            return this;
        }

        public final void setFilterRules(Collection<FilterRule.BuilderImpl> filterRules) {
            this.filterRules = FilterRuleListCopier.copyFromBuilder(filterRules);
        }

        public S3KeyFilter build() {
            return new S3KeyFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3KeyFilter> {
        public Builder filterRules(Collection<FilterRule> var1);

        public Builder filterRules(FilterRule ... var1);
    }
}

