/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.s3.model.Event;
import software.amazon.awssdk.services.s3.model.EventListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueueConfigurationDeprecated
implements ToCopyableBuilder<Builder, QueueConfigurationDeprecated> {
    private final String id;
    private final String event;
    private final List<String> events;
    private final String queue;

    private QueueConfigurationDeprecated(BuilderImpl builder) {
        this.id = builder.id;
        this.event = builder.event;
        this.events = builder.events;
        this.queue = builder.queue;
    }

    public String id() {
        return this.id;
    }

    public Event event() {
        return Event.fromValue(this.event);
    }

    public String eventString() {
        return this.event;
    }

    public List<Event> events() {
        return TypeConverter.convert(this.events, Event::fromValue);
    }

    public List<String> eventsStrings() {
        return this.events;
    }

    public String queue() {
        return this.queue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueConfigurationDeprecated)) {
            return false;
        }
        QueueConfigurationDeprecated other = (QueueConfigurationDeprecated)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.eventString(), other.eventString()) && Objects.equals(this.eventsStrings(), other.eventsStrings()) && Objects.equals(this.queue(), other.queue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.eventString() != null) {
            sb.append("Event: ").append(this.eventString()).append(",");
        }
        if (this.eventsStrings() != null) {
            sb.append("Events: ").append(this.eventsStrings()).append(",");
        }
        if (this.queue() != null) {
            sb.append("Queue: ").append(this.queue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Event": {
                return Optional.of(clazz.cast(this.eventString()));
            }
            case "Events": {
                return Optional.of(clazz.cast(this.eventsStrings()));
            }
            case "Queue": {
                return Optional.of(clazz.cast(this.queue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String event;
        private List<String> events;
        private String queue;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueConfigurationDeprecated model) {
            this.id(model.id);
            this.event(model.event);
            this.events(model.events);
            this.queue(model.queue);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEvent() {
            return this.event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        public final String getQueue() {
            return this.queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public QueueConfigurationDeprecated build() {
            return new QueueConfigurationDeprecated(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueueConfigurationDeprecated> {
        public Builder id(String var1);

        public Builder event(String var1);

        public Builder event(Event var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);

        public Builder queue(String var1);
    }
}

