/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.s3.model.NotificationConfiguration;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketNotificationConfigurationRequest
extends S3Request
implements ToCopyableBuilder<Builder, PutBucketNotificationConfigurationRequest> {
    private final String bucket;
    private final NotificationConfiguration notificationConfiguration;

    private PutBucketNotificationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.notificationConfiguration = builder.notificationConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketNotificationConfigurationRequest)) {
            return false;
        }
        PutBucketNotificationConfigurationRequest other = (PutBucketNotificationConfigurationRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.notificationConfiguration(), other.notificationConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.notificationConfiguration() != null) {
            sb.append("NotificationConfiguration: ").append(this.notificationConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "NotificationConfiguration": {
                return Optional.of(clazz.cast(this.notificationConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private NotificationConfiguration notificationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketNotificationConfigurationRequest model) {
            this.bucket(model.bucket);
            this.notificationConfiguration(model.notificationConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return this.notificationConfiguration != null ? this.notificationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutBucketNotificationConfigurationRequest build() {
            return new PutBucketNotificationConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    CopyableBuilder<Builder, PutBucketNotificationConfigurationRequest> {
        public Builder bucket(String var1);

        public Builder notificationConfiguration(NotificationConfiguration var1);

        default public Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return this.notificationConfiguration((NotificationConfiguration)((NotificationConfiguration.Builder)NotificationConfiguration.builder().apply(notificationConfiguration)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

