/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPartsRequest
extends S3Request
implements ToCopyableBuilder<Builder, ListPartsRequest> {
    private final String bucket;
    private final String key;
    private final Integer maxParts;
    private final Integer partNumberMarker;
    private final String uploadId;
    private final String requestPayer;

    private ListPartsRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.maxParts = builder.maxParts;
        this.partNumberMarker = builder.partNumberMarker;
        this.uploadId = builder.uploadId;
        this.requestPayer = builder.requestPayer;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public Integer maxParts() {
        return this.maxParts;
    }

    public Integer partNumberMarker() {
        return this.partNumberMarker;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(this.requestPayer);
    }

    public String requestPayerString() {
        return this.requestPayer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxParts());
        hashCode = 31 * hashCode + Objects.hashCode(this.partNumberMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestPayerString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartsRequest)) {
            return false;
        }
        ListPartsRequest other = (ListPartsRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.maxParts(), other.maxParts()) && Objects.equals(this.partNumberMarker(), other.partNumberMarker()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.requestPayerString(), other.requestPayerString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.maxParts() != null) {
            sb.append("MaxParts: ").append(this.maxParts()).append(",");
        }
        if (this.partNumberMarker() != null) {
            sb.append("PartNumberMarker: ").append(this.partNumberMarker()).append(",");
        }
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (this.requestPayerString() != null) {
            sb.append("RequestPayer: ").append(this.requestPayerString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "MaxParts": {
                return Optional.of(clazz.cast(this.maxParts()));
            }
            case "PartNumberMarker": {
                return Optional.of(clazz.cast(this.partNumberMarker()));
            }
            case "UploadId": {
                return Optional.of(clazz.cast(this.uploadId()));
            }
            case "RequestPayer": {
                return Optional.of(clazz.cast(this.requestPayerString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private String key;
        private Integer maxParts;
        private Integer partNumberMarker;
        private String uploadId;
        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartsRequest model) {
            this.bucket(model.bucket);
            this.key(model.key);
            this.maxParts(model.maxParts);
            this.partNumberMarker(model.partNumberMarker);
            this.uploadId(model.uploadId);
            this.requestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Integer getMaxParts() {
            return this.maxParts;
        }

        @Override
        public final Builder maxParts(Integer maxParts) {
            this.maxParts = maxParts;
            return this;
        }

        public final void setMaxParts(Integer maxParts) {
            this.maxParts = maxParts;
        }

        public final Integer getPartNumberMarker() {
            return this.partNumberMarker;
        }

        @Override
        public final Builder partNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        public final void setPartNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListPartsRequest build() {
            return new ListPartsRequest(this);
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    CopyableBuilder<Builder, ListPartsRequest> {
        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder maxParts(Integer var1);

        public Builder partNumberMarker(Integer var1);

        public Builder uploadId(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

