/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.s3.model.InventoryDestination;
import software.amazon.awssdk.services.s3.model.InventoryFilter;
import software.amazon.awssdk.services.s3.model.InventoryIncludedObjectVersions;
import software.amazon.awssdk.services.s3.model.InventoryOptionalField;
import software.amazon.awssdk.services.s3.model.InventoryOptionalFieldsCopier;
import software.amazon.awssdk.services.s3.model.InventorySchedule;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InventoryConfiguration
implements ToCopyableBuilder<Builder, InventoryConfiguration> {
    private final InventoryDestination destination;
    private final Boolean isEnabled;
    private final InventoryFilter filter;
    private final String id;
    private final String includedObjectVersions;
    private final List<String> optionalFields;
    private final InventorySchedule schedule;

    private InventoryConfiguration(BuilderImpl builder) {
        this.destination = builder.destination;
        this.isEnabled = builder.isEnabled;
        this.filter = builder.filter;
        this.id = builder.id;
        this.includedObjectVersions = builder.includedObjectVersions;
        this.optionalFields = builder.optionalFields;
        this.schedule = builder.schedule;
    }

    public InventoryDestination destination() {
        return this.destination;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public InventoryFilter filter() {
        return this.filter;
    }

    public String id() {
        return this.id;
    }

    public InventoryIncludedObjectVersions includedObjectVersions() {
        return InventoryIncludedObjectVersions.fromValue(this.includedObjectVersions);
    }

    public String includedObjectVersionsString() {
        return this.includedObjectVersions;
    }

    public List<InventoryOptionalField> optionalFields() {
        return TypeConverter.convert(this.optionalFields, InventoryOptionalField::fromValue);
    }

    public List<String> optionalFieldsStrings() {
        return this.optionalFields;
    }

    public InventorySchedule schedule() {
        return this.schedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.includedObjectVersionsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionalFieldsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryConfiguration)) {
            return false;
        }
        InventoryConfiguration other = (InventoryConfiguration)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.includedObjectVersionsString(), other.includedObjectVersionsString()) && Objects.equals(this.optionalFieldsStrings(), other.optionalFieldsStrings()) && Objects.equals(this.schedule(), other.schedule());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.destination() != null) {
            sb.append("Destination: ").append(this.destination()).append(",");
        }
        if (this.isEnabled() != null) {
            sb.append("IsEnabled: ").append(this.isEnabled()).append(",");
        }
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.includedObjectVersionsString() != null) {
            sb.append("IncludedObjectVersions: ").append(this.includedObjectVersionsString()).append(",");
        }
        if (this.optionalFieldsStrings() != null) {
            sb.append("OptionalFields: ").append(this.optionalFieldsStrings()).append(",");
        }
        if (this.schedule() != null) {
            sb.append("Schedule: ").append(this.schedule()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.of(clazz.cast(this.destination()));
            }
            case "IsEnabled": {
                return Optional.of(clazz.cast(this.isEnabled()));
            }
            case "Filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "IncludedObjectVersions": {
                return Optional.of(clazz.cast(this.includedObjectVersionsString()));
            }
            case "OptionalFields": {
                return Optional.of(clazz.cast(this.optionalFieldsStrings()));
            }
            case "Schedule": {
                return Optional.of(clazz.cast(this.schedule()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private InventoryDestination destination;
        private Boolean isEnabled;
        private InventoryFilter filter;
        private String id;
        private String includedObjectVersions;
        private List<String> optionalFields;
        private InventorySchedule schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryConfiguration model) {
            this.destination(model.destination);
            this.isEnabled(model.isEnabled);
            this.filter(model.filter);
            this.id(model.id);
            this.includedObjectVersions(model.includedObjectVersions);
            this.optionalFields(model.optionalFields);
            this.schedule(model.schedule);
        }

        public final InventoryDestination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(InventoryDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(InventoryDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Boolean getIsEnabled() {
            return this.isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public final InventoryFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(InventoryFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(InventoryFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIncludedObjectVersions() {
            return this.includedObjectVersions;
        }

        @Override
        public final Builder includedObjectVersions(String includedObjectVersions) {
            this.includedObjectVersions = includedObjectVersions;
            return this;
        }

        @Override
        public final Builder includedObjectVersions(InventoryIncludedObjectVersions includedObjectVersions) {
            this.includedObjectVersions(includedObjectVersions.toString());
            return this;
        }

        public final void setIncludedObjectVersions(String includedObjectVersions) {
            this.includedObjectVersions = includedObjectVersions;
        }

        public final Collection<String> getOptionalFields() {
            return this.optionalFields;
        }

        @Override
        public final Builder optionalFields(Collection<String> optionalFields) {
            this.optionalFields = InventoryOptionalFieldsCopier.copy(optionalFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionalFields(String ... optionalFields) {
            this.optionalFields(Arrays.asList(optionalFields));
            return this;
        }

        public final void setOptionalFields(Collection<String> optionalFields) {
            this.optionalFields = InventoryOptionalFieldsCopier.copy(optionalFields);
        }

        public final InventorySchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(InventorySchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(InventorySchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public InventoryConfiguration build() {
            return new InventoryConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InventoryConfiguration> {
        public Builder destination(InventoryDestination var1);

        default public Builder destination(Consumer<InventoryDestination.Builder> destination) {
            return this.destination((InventoryDestination)((InventoryDestination.Builder)InventoryDestination.builder().apply(destination)).build());
        }

        public Builder isEnabled(Boolean var1);

        public Builder filter(InventoryFilter var1);

        default public Builder filter(Consumer<InventoryFilter.Builder> filter) {
            return this.filter((InventoryFilter)((InventoryFilter.Builder)InventoryFilter.builder().apply(filter)).build());
        }

        public Builder id(String var1);

        public Builder includedObjectVersions(String var1);

        public Builder includedObjectVersions(InventoryIncludedObjectVersions var1);

        public Builder optionalFields(Collection<String> var1);

        public Builder optionalFields(String ... var1);

        public Builder schedule(InventorySchedule var1);

        default public Builder schedule(Consumer<InventorySchedule.Builder> schedule) {
            return this.schedule((InventorySchedule)((InventorySchedule.Builder)InventorySchedule.builder().apply(schedule)).build());
        }
    }
}

