/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.CORSRule;
import software.amazon.awssdk.services.s3.model.CORSRulesCopier;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBucketCorsResponse
extends S3Response
implements ToCopyableBuilder<Builder, GetBucketCorsResponse> {
    private final List<CORSRule> corsRules;

    private GetBucketCorsResponse(BuilderImpl builder) {
        super(builder);
        this.corsRules = builder.corsRules;
    }

    public List<CORSRule> corsRules() {
        return this.corsRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.corsRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketCorsResponse)) {
            return false;
        }
        GetBucketCorsResponse other = (GetBucketCorsResponse)((Object)obj);
        return Objects.equals(this.corsRules(), other.corsRules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.corsRules() != null) {
            sb.append("CORSRules: ").append(this.corsRules()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CORSRules": {
                return Optional.of(clazz.cast(this.corsRules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private List<CORSRule> corsRules;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketCorsResponse model) {
            this.corsRules(model.corsRules);
        }

        public final Collection<CORSRule.Builder> getCORSRules() {
            return this.corsRules != null ? (Collection)this.corsRules.stream().map(CORSRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder corsRules(Collection<CORSRule> corsRules) {
            this.corsRules = CORSRulesCopier.copy(corsRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder corsRules(CORSRule ... corsRules) {
            this.corsRules(Arrays.asList(corsRules));
            return this;
        }

        public final void setCORSRules(Collection<CORSRule.BuilderImpl> corsRules) {
            this.corsRules = CORSRulesCopier.copyFromBuilder(corsRules);
        }

        @Override
        public GetBucketCorsResponse build() {
            return new GetBucketCorsResponse(this);
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    CopyableBuilder<Builder, GetBucketCorsResponse> {
        public Builder corsRules(Collection<CORSRule> var1);

        public Builder corsRules(CORSRule ... var1);
    }
}

