/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.AllowedHeadersCopier;
import software.amazon.awssdk.services.s3.model.AllowedMethodsCopier;
import software.amazon.awssdk.services.s3.model.AllowedOriginsCopier;
import software.amazon.awssdk.services.s3.model.ExposeHeadersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CORSRule
implements ToCopyableBuilder<Builder, CORSRule> {
    private final List<String> allowedHeaders;
    private final List<String> allowedMethods;
    private final List<String> allowedOrigins;
    private final List<String> exposeHeaders;
    private final Integer maxAgeSeconds;

    private CORSRule(BuilderImpl builder) {
        this.allowedHeaders = builder.allowedHeaders;
        this.allowedMethods = builder.allowedMethods;
        this.allowedOrigins = builder.allowedOrigins;
        this.exposeHeaders = builder.exposeHeaders;
        this.maxAgeSeconds = builder.maxAgeSeconds;
    }

    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    public List<String> allowedMethods() {
        return this.allowedMethods;
    }

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public List<String> exposeHeaders() {
        return this.exposeHeaders;
    }

    public Integer maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedMethods());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedOrigins());
        hashCode = 31 * hashCode + Objects.hashCode(this.exposeHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAgeSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CORSRule)) {
            return false;
        }
        CORSRule other = (CORSRule)obj;
        return Objects.equals(this.allowedHeaders(), other.allowedHeaders()) && Objects.equals(this.allowedMethods(), other.allowedMethods()) && Objects.equals(this.allowedOrigins(), other.allowedOrigins()) && Objects.equals(this.exposeHeaders(), other.exposeHeaders()) && Objects.equals(this.maxAgeSeconds(), other.maxAgeSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.allowedHeaders() != null) {
            sb.append("AllowedHeaders: ").append(this.allowedHeaders()).append(",");
        }
        if (this.allowedMethods() != null) {
            sb.append("AllowedMethods: ").append(this.allowedMethods()).append(",");
        }
        if (this.allowedOrigins() != null) {
            sb.append("AllowedOrigins: ").append(this.allowedOrigins()).append(",");
        }
        if (this.exposeHeaders() != null) {
            sb.append("ExposeHeaders: ").append(this.exposeHeaders()).append(",");
        }
        if (this.maxAgeSeconds() != null) {
            sb.append("MaxAgeSeconds: ").append(this.maxAgeSeconds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedHeaders": {
                return Optional.of(clazz.cast(this.allowedHeaders()));
            }
            case "AllowedMethods": {
                return Optional.of(clazz.cast(this.allowedMethods()));
            }
            case "AllowedOrigins": {
                return Optional.of(clazz.cast(this.allowedOrigins()));
            }
            case "ExposeHeaders": {
                return Optional.of(clazz.cast(this.exposeHeaders()));
            }
            case "MaxAgeSeconds": {
                return Optional.of(clazz.cast(this.maxAgeSeconds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedHeaders;
        private List<String> allowedMethods;
        private List<String> allowedOrigins;
        private List<String> exposeHeaders;
        private Integer maxAgeSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CORSRule model) {
            this.allowedHeaders(model.allowedHeaders);
            this.allowedMethods(model.allowedMethods);
            this.allowedOrigins(model.allowedOrigins);
            this.exposeHeaders(model.exposeHeaders);
            this.maxAgeSeconds(model.maxAgeSeconds);
        }

        public final Collection<String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        @Override
        public final Builder allowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedHeaders(String ... allowedHeaders) {
            this.allowedHeaders(Arrays.asList(allowedHeaders));
            return this;
        }

        public final void setAllowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
        }

        public final Collection<String> getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public final Builder allowedMethods(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMethods(String ... allowedMethods) {
            this.allowedMethods(Arrays.asList(allowedMethods));
            return this;
        }

        public final void setAllowedMethods(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
        }

        public final Collection<String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Override
        public final Builder allowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOrigins(String ... allowedOrigins) {
            this.allowedOrigins(Arrays.asList(allowedOrigins));
            return this;
        }

        public final void setAllowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
        }

        public final Collection<String> getExposeHeaders() {
            return this.exposeHeaders;
        }

        @Override
        public final Builder exposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exposeHeaders(String ... exposeHeaders) {
            this.exposeHeaders(Arrays.asList(exposeHeaders));
            return this;
        }

        public final void setExposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
        }

        public final Integer getMaxAgeSeconds() {
            return this.maxAgeSeconds;
        }

        @Override
        public final Builder maxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public final void setMaxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
        }

        public CORSRule build() {
            return new CORSRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CORSRule> {
        public Builder allowedHeaders(Collection<String> var1);

        public Builder allowedHeaders(String ... var1);

        public Builder allowedMethods(Collection<String> var1);

        public Builder allowedMethods(String ... var1);

        public Builder allowedOrigins(Collection<String> var1);

        public Builder allowedOrigins(String ... var1);

        public Builder exposeHeaders(Collection<String> var1);

        public Builder exposeHeaders(String ... var1);

        public Builder maxAgeSeconds(Integer var1);
    }
}

