/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.services.s3.transform.TagUnmarshaller;

public class TaggingUnmarshaller
implements Unmarshaller<Tagging, StaxUnmarshallerContext> {
    private static final TaggingUnmarshaller INSTANCE = new TaggingUnmarshaller();

    public Tagging unmarshall(StaxUnmarshallerContext context) throws Exception {
        Tagging.Builder tagging;
        block5: {
            tagging = Tagging.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Tag> tagSet = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    tagging.tagSet(tagSet);
                    break block5;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("TagSet", targetDepth)) {
                        tagSet = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("TagSet/Tag", targetDepth)) continue;
                    tagSet.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            tagging.tagSet(tagSet);
        }
        return (Tagging)tagging.build();
    }

    public static TaggingUnmarshaller getInstance() {
        return INSTANCE;
    }
}

