/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;

public class ListObjectsV2RequestMarshaller
implements Marshaller<Request<ListObjectsV2Request>, ListObjectsV2Request> {
    public Request<ListObjectsV2Request> marshall(ListObjectsV2Request listObjectsV2Request) {
        if (listObjectsV2Request == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listObjectsV2Request, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (listObjectsV2Request.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)listObjectsV2Request.requestPayerString()));
        }
        String uriResourcePath = "/{Bucket}?list-type=2";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", listObjectsV2Request.bucket());
        request.setResourcePath(uriResourcePath);
        if (listObjectsV2Request.delimiter() != null) {
            request.addParameter("delimiter", StringUtils.fromString((String)listObjectsV2Request.delimiter()));
        }
        if (listObjectsV2Request.encodingTypeString() != null) {
            request.addParameter("encoding-type", StringUtils.fromString((String)listObjectsV2Request.encodingTypeString()));
        }
        if (listObjectsV2Request.maxKeys() != null) {
            request.addParameter("max-keys", StringUtils.fromInteger((Integer)listObjectsV2Request.maxKeys()));
        }
        if (listObjectsV2Request.prefix() != null) {
            request.addParameter("prefix", StringUtils.fromString((String)listObjectsV2Request.prefix()));
        }
        if (listObjectsV2Request.continuationToken() != null) {
            request.addParameter("continuation-token", StringUtils.fromString((String)listObjectsV2Request.continuationToken()));
        }
        if (listObjectsV2Request.fetchOwner() != null) {
            request.addParameter("fetch-owner", StringUtils.fromBoolean((Boolean)listObjectsV2Request.fetchOwner()));
        }
        if (listObjectsV2Request.startAfter() != null) {
            request.addParameter("start-after", StringUtils.fromString((String)listObjectsV2Request.startAfter()));
        }
        return request;
    }
}

