/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.Protocol;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RedirectAllRequestsTo
implements ToCopyableBuilder<Builder, RedirectAllRequestsTo> {
    private final String hostName;
    private final String protocol;

    private RedirectAllRequestsTo(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.protocol = builder.protocol;
    }

    public String hostName() {
        return this.hostName;
    }

    public Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public String protocolString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostName());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedirectAllRequestsTo)) {
            return false;
        }
        RedirectAllRequestsTo other = (RedirectAllRequestsTo)obj;
        return Objects.equals(this.hostName(), other.hostName()) && Objects.equals(this.protocolString(), other.protocolString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostName() != null) {
            sb.append("HostName: ").append(this.hostName()).append(",");
        }
        if (this.protocolString() != null) {
            sb.append("Protocol: ").append(this.protocolString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostName": {
                return Optional.of(clazz.cast(this.hostName()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocolString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hostName;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(RedirectAllRequestsTo model) {
            this.hostName(model.hostName);
            this.protocol(model.protocol);
        }

        public final String getHostName() {
            return this.hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public RedirectAllRequestsTo build() {
            return new RedirectAllRequestsTo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RedirectAllRequestsTo> {
        public Builder hostName(String var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);
    }
}

