/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ObjectIdentifier
implements ToCopyableBuilder<Builder, ObjectIdentifier> {
    private final String key;
    private final String versionId;

    private ObjectIdentifier(BuilderImpl builder) {
        this.key = builder.key;
        this.versionId = builder.versionId;
    }

    public String key() {
        return this.key;
    }

    public String versionId() {
        return this.versionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectIdentifier)) {
            return false;
        }
        ObjectIdentifier other = (ObjectIdentifier)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.versionId(), other.versionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectIdentifier model) {
            this.key(model.key);
            this.versionId(model.versionId);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public ObjectIdentifier build() {
            return new ObjectIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ObjectIdentifier> {
        public Builder key(String var1);

        public Builder versionId(String var1);
    }
}

