/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.TopicConfiguration;
import software.amazon.awssdk.services.s3.transform.NotificationConfigurationFilterUnmarshaller;

public class TopicConfigurationUnmarshaller
implements Unmarshaller<TopicConfiguration, StaxUnmarshallerContext> {
    private static final TopicConfigurationUnmarshaller INSTANCE = new TopicConfigurationUnmarshaller();

    public TopicConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        TopicConfiguration.Builder topicConfiguration;
        block8: {
            topicConfiguration = TopicConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> events = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    topicConfiguration.events(events);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Id", targetDepth)) {
                        topicConfiguration.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Topic", targetDepth)) {
                        topicConfiguration.topicArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Event", targetDepth)) {
                        if (events == null) {
                            events = new ArrayList<String>();
                        }
                        events.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Filter", targetDepth)) continue;
                    topicConfiguration.filter(NotificationConfigurationFilterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            topicConfiguration.events(events);
        }
        return (TopicConfiguration)topicConfiguration.build();
    }

    public static TopicConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

