/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload;
import software.amazon.awssdk.services.s3.model.ExpirationStatus;
import software.amazon.awssdk.services.s3.model.LifecycleExpiration;
import software.amazon.awssdk.services.s3.model.LifecycleRuleFilter;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionTransitionListCopier;
import software.amazon.awssdk.services.s3.model.Transition;
import software.amazon.awssdk.services.s3.model.TransitionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LifecycleRule
implements ToCopyableBuilder<Builder, LifecycleRule> {
    private final LifecycleExpiration expiration;
    private final String id;
    private final String prefix;
    private final LifecycleRuleFilter filter;
    private final String status;
    private final List<Transition> transitions;
    private final List<NoncurrentVersionTransition> noncurrentVersionTransitions;
    private final NoncurrentVersionExpiration noncurrentVersionExpiration;
    private final AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

    private LifecycleRule(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.id = builder.id;
        this.prefix = builder.prefix;
        this.filter = builder.filter;
        this.status = builder.status;
        this.transitions = builder.transitions;
        this.noncurrentVersionTransitions = builder.noncurrentVersionTransitions;
        this.noncurrentVersionExpiration = builder.noncurrentVersionExpiration;
        this.abortIncompleteMultipartUpload = builder.abortIncompleteMultipartUpload;
    }

    public LifecycleExpiration expiration() {
        return this.expiration;
    }

    public String id() {
        return this.id;
    }

    public String prefix() {
        return this.prefix;
    }

    public LifecycleRuleFilter filter() {
        return this.filter;
    }

    public ExpirationStatus status() {
        return ExpirationStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public List<Transition> transitions() {
        return this.transitions;
    }

    public List<NoncurrentVersionTransition> noncurrentVersionTransitions() {
        return this.noncurrentVersionTransitions;
    }

    public NoncurrentVersionExpiration noncurrentVersionExpiration() {
        return this.noncurrentVersionExpiration;
    }

    public AbortIncompleteMultipartUpload abortIncompleteMultipartUpload() {
        return this.abortIncompleteMultipartUpload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.expiration() == null ? 0 : this.expiration().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.transitions() == null ? 0 : this.transitions().hashCode());
        hashCode = 31 * hashCode + (this.noncurrentVersionTransitions() == null ? 0 : this.noncurrentVersionTransitions().hashCode());
        hashCode = 31 * hashCode + (this.noncurrentVersionExpiration() == null ? 0 : this.noncurrentVersionExpiration().hashCode());
        hashCode = 31 * hashCode + (this.abortIncompleteMultipartUpload() == null ? 0 : this.abortIncompleteMultipartUpload().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleRule)) {
            return false;
        }
        LifecycleRule other = (LifecycleRule)obj;
        if (other.expiration() == null ^ this.expiration() == null) {
            return false;
        }
        if (other.expiration() != null && !other.expiration().equals(this.expiration())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        if (other.filter() != null && !other.filter().equals(this.filter())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.transitions() == null ^ this.transitions() == null) {
            return false;
        }
        if (other.transitions() != null && !other.transitions().equals(this.transitions())) {
            return false;
        }
        if (other.noncurrentVersionTransitions() == null ^ this.noncurrentVersionTransitions() == null) {
            return false;
        }
        if (other.noncurrentVersionTransitions() != null && !other.noncurrentVersionTransitions().equals(this.noncurrentVersionTransitions())) {
            return false;
        }
        if (other.noncurrentVersionExpiration() == null ^ this.noncurrentVersionExpiration() == null) {
            return false;
        }
        if (other.noncurrentVersionExpiration() != null && !other.noncurrentVersionExpiration().equals(this.noncurrentVersionExpiration())) {
            return false;
        }
        if (other.abortIncompleteMultipartUpload() == null ^ this.abortIncompleteMultipartUpload() == null) {
            return false;
        }
        return other.abortIncompleteMultipartUpload() == null || other.abortIncompleteMultipartUpload().equals(this.abortIncompleteMultipartUpload());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.expiration() != null) {
            sb.append("Expiration: ").append(this.expiration()).append(",");
        }
        if (this.id() != null) {
            sb.append("ID: ").append(this.id()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.transitions() != null) {
            sb.append("Transitions: ").append(this.transitions()).append(",");
        }
        if (this.noncurrentVersionTransitions() != null) {
            sb.append("NoncurrentVersionTransitions: ").append(this.noncurrentVersionTransitions()).append(",");
        }
        if (this.noncurrentVersionExpiration() != null) {
            sb.append("NoncurrentVersionExpiration: ").append(this.noncurrentVersionExpiration()).append(",");
        }
        if (this.abortIncompleteMultipartUpload() != null) {
            sb.append("AbortIncompleteMultipartUpload: ").append(this.abortIncompleteMultipartUpload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expiration": {
                return Optional.of(clazz.cast(this.expiration()));
            }
            case "ID": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "Filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "Transitions": {
                return Optional.of(clazz.cast(this.transitions()));
            }
            case "NoncurrentVersionTransitions": {
                return Optional.of(clazz.cast(this.noncurrentVersionTransitions()));
            }
            case "NoncurrentVersionExpiration": {
                return Optional.of(clazz.cast(this.noncurrentVersionExpiration()));
            }
            case "AbortIncompleteMultipartUpload": {
                return Optional.of(clazz.cast(this.abortIncompleteMultipartUpload()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private LifecycleExpiration expiration;
        private String id;
        private String prefix;
        private LifecycleRuleFilter filter;
        private String status;
        private List<Transition> transitions;
        private List<NoncurrentVersionTransition> noncurrentVersionTransitions;
        private NoncurrentVersionExpiration noncurrentVersionExpiration;
        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleRule model) {
            this.expiration(model.expiration);
            this.id(model.id);
            this.prefix(model.prefix);
            this.filter(model.filter);
            this.status(model.status);
            this.transitions(model.transitions);
            this.noncurrentVersionTransitions(model.noncurrentVersionTransitions);
            this.noncurrentVersionExpiration(model.noncurrentVersionExpiration);
            this.abortIncompleteMultipartUpload(model.abortIncompleteMultipartUpload);
        }

        public final LifecycleExpiration.Builder getExpiration() {
            return this.expiration != null ? this.expiration.toBuilder() : null;
        }

        @Override
        public final Builder expiration(LifecycleExpiration expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(LifecycleExpiration.BuilderImpl expiration) {
            this.expiration = expiration != null ? expiration.build() : null;
        }

        public final String getID() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final LifecycleRuleFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(LifecycleRuleFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(LifecycleRuleFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExpirationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<Transition.Builder> getTransitions() {
            return this.transitions != null ? (Collection)this.transitions.stream().map(Transition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transitions(Collection<Transition> transitions) {
            this.transitions = TransitionListCopier.copy(transitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(Transition ... transitions) {
            this.transitions(Arrays.asList(transitions));
            return this;
        }

        public final void setTransitions(Collection<Transition.BuilderImpl> transitions) {
            this.transitions = TransitionListCopier.copyFromBuilder(transitions);
        }

        public final Collection<NoncurrentVersionTransition.Builder> getNoncurrentVersionTransitions() {
            return this.noncurrentVersionTransitions != null ? (Collection)this.noncurrentVersionTransitions.stream().map(NoncurrentVersionTransition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder noncurrentVersionTransitions(Collection<NoncurrentVersionTransition> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = NoncurrentVersionTransitionListCopier.copy(noncurrentVersionTransitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder noncurrentVersionTransitions(NoncurrentVersionTransition ... noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions(Arrays.asList(noncurrentVersionTransitions));
            return this;
        }

        public final void setNoncurrentVersionTransitions(Collection<NoncurrentVersionTransition.BuilderImpl> noncurrentVersionTransitions) {
            this.noncurrentVersionTransitions = NoncurrentVersionTransitionListCopier.copyFromBuilder(noncurrentVersionTransitions);
        }

        public final NoncurrentVersionExpiration.Builder getNoncurrentVersionExpiration() {
            return this.noncurrentVersionExpiration != null ? this.noncurrentVersionExpiration.toBuilder() : null;
        }

        @Override
        public final Builder noncurrentVersionExpiration(NoncurrentVersionExpiration noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration;
            return this;
        }

        public final void setNoncurrentVersionExpiration(NoncurrentVersionExpiration.BuilderImpl noncurrentVersionExpiration) {
            this.noncurrentVersionExpiration = noncurrentVersionExpiration != null ? noncurrentVersionExpiration.build() : null;
        }

        public final AbortIncompleteMultipartUpload.Builder getAbortIncompleteMultipartUpload() {
            return this.abortIncompleteMultipartUpload != null ? this.abortIncompleteMultipartUpload.toBuilder() : null;
        }

        @Override
        public final Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload;
            return this;
        }

        public final void setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUpload.BuilderImpl abortIncompleteMultipartUpload) {
            this.abortIncompleteMultipartUpload = abortIncompleteMultipartUpload != null ? abortIncompleteMultipartUpload.build() : null;
        }

        public LifecycleRule build() {
            return new LifecycleRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LifecycleRule> {
        public Builder expiration(LifecycleExpiration var1);

        public Builder id(String var1);

        public Builder prefix(String var1);

        public Builder filter(LifecycleRuleFilter var1);

        public Builder status(String var1);

        public Builder status(ExpirationStatus var1);

        public Builder transitions(Collection<Transition> var1);

        public Builder transitions(Transition ... var1);

        public Builder noncurrentVersionTransitions(Collection<NoncurrentVersionTransition> var1);

        public Builder noncurrentVersionTransitions(NoncurrentVersionTransition ... var1);

        public Builder noncurrentVersionExpiration(NoncurrentVersionExpiration var1);

        public Builder abortIncompleteMultipartUpload(AbortIncompleteMultipartUpload var1);
    }
}

