/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.LifecycleRule;
import software.amazon.awssdk.services.s3.model.LifecycleRulesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BucketLifecycleConfiguration
implements ToCopyableBuilder<Builder, BucketLifecycleConfiguration> {
    private final List<LifecycleRule> rules;

    private BucketLifecycleConfiguration(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    public List<LifecycleRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.rules() == null ? 0 : this.rules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketLifecycleConfiguration)) {
            return false;
        }
        BucketLifecycleConfiguration other = (BucketLifecycleConfiguration)obj;
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        return other.rules() == null || other.rules().equals(this.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<LifecycleRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketLifecycleConfiguration model) {
            this.rules(model.rules);
        }

        public final Collection<LifecycleRule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(LifecycleRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<LifecycleRule> rules) {
            this.rules = LifecycleRulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(LifecycleRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<LifecycleRule.BuilderImpl> rules) {
            this.rules = LifecycleRulesCopier.copyFromBuilder(rules);
        }

        public BucketLifecycleConfiguration build() {
            return new BucketLifecycleConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BucketLifecycleConfiguration> {
        public Builder rules(Collection<LifecycleRule> var1);

        public Builder rules(LifecycleRule ... var1);
    }
}

