/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.InventoryConfiguration;
import software.amazon.awssdk.services.s3.model.InventoryConfigurationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBucketInventoryConfigurationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListBucketInventoryConfigurationsResponse> {
    private final String continuationToken;
    private final List<InventoryConfiguration> inventoryConfigurationList;
    private final Boolean isTruncated;
    private final String nextContinuationToken;

    private ListBucketInventoryConfigurationsResponse(BuilderImpl builder) {
        this.continuationToken = builder.continuationToken;
        this.inventoryConfigurationList = builder.inventoryConfigurationList;
        this.isTruncated = builder.isTruncated;
        this.nextContinuationToken = builder.nextContinuationToken;
    }

    public String continuationToken() {
        return this.continuationToken;
    }

    public List<InventoryConfiguration> inventoryConfigurationList() {
        return this.inventoryConfigurationList;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextContinuationToken() {
        return this.nextContinuationToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.continuationToken() == null ? 0 : this.continuationToken().hashCode());
        hashCode = 31 * hashCode + (this.inventoryConfigurationList() == null ? 0 : this.inventoryConfigurationList().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.nextContinuationToken() == null ? 0 : this.nextContinuationToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketInventoryConfigurationsResponse)) {
            return false;
        }
        ListBucketInventoryConfigurationsResponse other = (ListBucketInventoryConfigurationsResponse)((Object)obj);
        if (other.continuationToken() == null ^ this.continuationToken() == null) {
            return false;
        }
        if (other.continuationToken() != null && !other.continuationToken().equals(this.continuationToken())) {
            return false;
        }
        if (other.inventoryConfigurationList() == null ^ this.inventoryConfigurationList() == null) {
            return false;
        }
        if (other.inventoryConfigurationList() != null && !other.inventoryConfigurationList().equals(this.inventoryConfigurationList())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextContinuationToken() == null ^ this.nextContinuationToken() == null) {
            return false;
        }
        return other.nextContinuationToken() == null || other.nextContinuationToken().equals(this.nextContinuationToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.continuationToken() != null) {
            sb.append("ContinuationToken: ").append(this.continuationToken()).append(",");
        }
        if (this.inventoryConfigurationList() != null) {
            sb.append("InventoryConfigurationList: ").append(this.inventoryConfigurationList()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.nextContinuationToken() != null) {
            sb.append("NextContinuationToken: ").append(this.nextContinuationToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String continuationToken;
        private List<InventoryConfiguration> inventoryConfigurationList;
        private Boolean isTruncated;
        private String nextContinuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketInventoryConfigurationsResponse model) {
            this.setContinuationToken(model.continuationToken);
            this.setInventoryConfigurationList(model.inventoryConfigurationList);
            this.setIsTruncated(model.isTruncated);
            this.setNextContinuationToken(model.nextContinuationToken);
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final Collection<InventoryConfiguration> getInventoryConfigurationList() {
            return this.inventoryConfigurationList;
        }

        @Override
        public final Builder inventoryConfigurationList(Collection<InventoryConfiguration> inventoryConfigurationList) {
            this.inventoryConfigurationList = InventoryConfigurationListCopier.copy(inventoryConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inventoryConfigurationList(InventoryConfiguration ... inventoryConfigurationList) {
            this.inventoryConfigurationList(Arrays.asList(inventoryConfigurationList));
            return this;
        }

        public final void setInventoryConfigurationList(Collection<InventoryConfiguration> inventoryConfigurationList) {
            this.inventoryConfigurationList = InventoryConfigurationListCopier.copy(inventoryConfigurationList);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextContinuationToken() {
            return this.nextContinuationToken;
        }

        @Override
        public final Builder nextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
            return this;
        }

        public final void setNextContinuationToken(String nextContinuationToken) {
            this.nextContinuationToken = nextContinuationToken;
        }

        public ListBucketInventoryConfigurationsResponse build() {
            return new ListBucketInventoryConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListBucketInventoryConfigurationsResponse> {
        public Builder continuationToken(String var1);

        public Builder inventoryConfigurationList(Collection<InventoryConfiguration> var1);

        public Builder inventoryConfigurationList(InventoryConfiguration ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextContinuationToken(String var1);
    }
}

