/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.model.GrantsCopier;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBucketAclResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetBucketAclResponse> {
    private final Owner owner;
    private final List<Grant> grants;

    private GetBucketAclResponse(BuilderImpl builder) {
        this.owner = builder.owner;
        this.grants = builder.grants;
    }

    public Owner owner() {
        return this.owner;
    }

    public List<Grant> grants() {
        return this.grants;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        hashCode = 31 * hashCode + (this.grants() == null ? 0 : this.grants().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketAclResponse)) {
            return false;
        }
        GetBucketAclResponse other = (GetBucketAclResponse)((Object)obj);
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.grants() == null ^ this.grants() == null) {
            return false;
        }
        return other.grants() == null || other.grants().equals(this.grants());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.grants() != null) {
            sb.append("Grants: ").append(this.grants()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Owner owner;
        private List<Grant> grants;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketAclResponse model) {
            this.setOwner(model.owner);
            this.setGrants(model.grants);
        }

        public final Owner getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner owner) {
            this.owner = owner;
        }

        public final Collection<Grant> getGrants() {
            return this.grants;
        }

        @Override
        public final Builder grants(Collection<Grant> grants) {
            this.grants = GrantsCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Grant ... grants) {
            this.grants(Arrays.asList(grants));
            return this;
        }

        public final void setGrants(Collection<Grant> grants) {
            this.grants = GrantsCopier.copy(grants);
        }

        public GetBucketAclResponse build() {
            return new GetBucketAclResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetBucketAclResponse> {
        public Builder owner(Owner var1);

        public Builder grants(Collection<Grant> var1);

        public Builder grants(Grant ... var1);
    }
}

