/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.ReplicationConfiguration;
import software.amazon.awssdk.services.s3.model.ReplicationRule;
import software.amazon.awssdk.services.s3.transform.ReplicationRuleUnmarshaller;

public class ReplicationConfigurationUnmarshaller
implements Unmarshaller<ReplicationConfiguration, StaxUnmarshallerContext> {
    private static final ReplicationConfigurationUnmarshaller INSTANCE = new ReplicationConfigurationUnmarshaller();

    public ReplicationConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReplicationConfiguration.Builder replicationConfiguration;
        block6: {
            replicationConfiguration = ReplicationConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<ReplicationRule> rules = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    replicationConfiguration.rules(rules);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Role", targetDepth)) {
                        replicationConfiguration.role(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Rule", targetDepth)) continue;
                    if (rules == null) {
                        rules = new ArrayList<ReplicationRule>();
                    }
                    rules.add(ReplicationRuleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            replicationConfiguration.rules(rules);
        }
        return (ReplicationConfiguration)replicationConfiguration.build();
    }

    public static ReplicationConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

