/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListObjectVersionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListObjectVersionsRequest> {
    private final String bucket;
    private final String delimiter;
    private final String encodingType;
    private final String keyMarker;
    private final Integer maxKeys;
    private final String prefix;
    private final String versionIdMarker;

    private ListObjectVersionsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.keyMarker = builder.keyMarker;
        this.maxKeys = builder.maxKeys;
        this.prefix = builder.prefix;
        this.versionIdMarker = builder.versionIdMarker;
    }

    public String bucket() {
        return this.bucket;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public String encodingType() {
        return this.encodingType;
    }

    public String keyMarker() {
        return this.keyMarker;
    }

    public Integer maxKeys() {
        return this.maxKeys;
    }

    public String prefix() {
        return this.prefix;
    }

    public String versionIdMarker() {
        return this.versionIdMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.delimiter() == null ? 0 : this.delimiter().hashCode());
        hashCode = 31 * hashCode + (this.encodingType() == null ? 0 : this.encodingType().hashCode());
        hashCode = 31 * hashCode + (this.keyMarker() == null ? 0 : this.keyMarker().hashCode());
        hashCode = 31 * hashCode + (this.maxKeys() == null ? 0 : this.maxKeys().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.versionIdMarker() == null ? 0 : this.versionIdMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectVersionsRequest)) {
            return false;
        }
        ListObjectVersionsRequest other = (ListObjectVersionsRequest)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.encodingType() == null ^ this.encodingType() == null) {
            return false;
        }
        if (other.encodingType() != null && !other.encodingType().equals(this.encodingType())) {
            return false;
        }
        if (other.keyMarker() == null ^ this.keyMarker() == null) {
            return false;
        }
        if (other.keyMarker() != null && !other.keyMarker().equals(this.keyMarker())) {
            return false;
        }
        if (other.maxKeys() == null ^ this.maxKeys() == null) {
            return false;
        }
        if (other.maxKeys() != null && !other.maxKeys().equals(this.maxKeys())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.versionIdMarker() == null ^ this.versionIdMarker() == null) {
            return false;
        }
        return other.versionIdMarker() == null || other.versionIdMarker().equals(this.versionIdMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.delimiter() != null) {
            sb.append("Delimiter: ").append(this.delimiter()).append(",");
        }
        if (this.encodingType() != null) {
            sb.append("EncodingType: ").append(this.encodingType()).append(",");
        }
        if (this.keyMarker() != null) {
            sb.append("KeyMarker: ").append(this.keyMarker()).append(",");
        }
        if (this.maxKeys() != null) {
            sb.append("MaxKeys: ").append(this.maxKeys()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.versionIdMarker() != null) {
            sb.append("VersionIdMarker: ").append(this.versionIdMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String delimiter;
        private String encodingType;
        private String keyMarker;
        private Integer maxKeys;
        private String prefix;
        private String versionIdMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectVersionsRequest model) {
            this.setBucket(model.bucket);
            this.setDelimiter(model.delimiter);
            this.setEncodingType(model.encodingType);
            this.setKeyMarker(model.keyMarker);
            this.setMaxKeys(model.maxKeys);
            this.setPrefix(model.prefix);
            this.setVersionIdMarker(model.versionIdMarker);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final String getEncodingType() {
            return this.encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final String getKeyMarker() {
            return this.keyMarker;
        }

        @Override
        public final Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public final void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        public final Integer getMaxKeys() {
            return this.maxKeys;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public final void setMaxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getVersionIdMarker() {
            return this.versionIdMarker;
        }

        @Override
        public final Builder versionIdMarker(String versionIdMarker) {
            this.versionIdMarker = versionIdMarker;
            return this;
        }

        public final void setVersionIdMarker(String versionIdMarker) {
            this.versionIdMarker = versionIdMarker;
        }

        public ListObjectVersionsRequest build() {
            return new ListObjectVersionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListObjectVersionsRequest> {
        public Builder bucket(String var1);

        public Builder delimiter(String var1);

        public Builder encodingType(String var1);

        public Builder encodingType(EncodingType var1);

        public Builder keyMarker(String var1);

        public Builder maxKeys(Integer var1);

        public Builder prefix(String var1);

        public Builder versionIdMarker(String var1);
    }
}

