/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListMultipartUploadsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListMultipartUploadsRequest> {
    private final String bucket;
    private final String delimiter;
    private final String encodingType;
    private final String keyMarker;
    private final Integer maxUploads;
    private final String prefix;
    private final String uploadIdMarker;

    private ListMultipartUploadsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.delimiter = builder.delimiter;
        this.encodingType = builder.encodingType;
        this.keyMarker = builder.keyMarker;
        this.maxUploads = builder.maxUploads;
        this.prefix = builder.prefix;
        this.uploadIdMarker = builder.uploadIdMarker;
    }

    public String bucket() {
        return this.bucket;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public String encodingType() {
        return this.encodingType;
    }

    public String keyMarker() {
        return this.keyMarker;
    }

    public Integer maxUploads() {
        return this.maxUploads;
    }

    public String prefix() {
        return this.prefix;
    }

    public String uploadIdMarker() {
        return this.uploadIdMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.delimiter() == null ? 0 : this.delimiter().hashCode());
        hashCode = 31 * hashCode + (this.encodingType() == null ? 0 : this.encodingType().hashCode());
        hashCode = 31 * hashCode + (this.keyMarker() == null ? 0 : this.keyMarker().hashCode());
        hashCode = 31 * hashCode + (this.maxUploads() == null ? 0 : this.maxUploads().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.uploadIdMarker() == null ? 0 : this.uploadIdMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultipartUploadsRequest)) {
            return false;
        }
        ListMultipartUploadsRequest other = (ListMultipartUploadsRequest)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.encodingType() == null ^ this.encodingType() == null) {
            return false;
        }
        if (other.encodingType() != null && !other.encodingType().equals(this.encodingType())) {
            return false;
        }
        if (other.keyMarker() == null ^ this.keyMarker() == null) {
            return false;
        }
        if (other.keyMarker() != null && !other.keyMarker().equals(this.keyMarker())) {
            return false;
        }
        if (other.maxUploads() == null ^ this.maxUploads() == null) {
            return false;
        }
        if (other.maxUploads() != null && !other.maxUploads().equals(this.maxUploads())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.uploadIdMarker() == null ^ this.uploadIdMarker() == null) {
            return false;
        }
        return other.uploadIdMarker() == null || other.uploadIdMarker().equals(this.uploadIdMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.delimiter() != null) {
            sb.append("Delimiter: ").append(this.delimiter()).append(",");
        }
        if (this.encodingType() != null) {
            sb.append("EncodingType: ").append(this.encodingType()).append(",");
        }
        if (this.keyMarker() != null) {
            sb.append("KeyMarker: ").append(this.keyMarker()).append(",");
        }
        if (this.maxUploads() != null) {
            sb.append("MaxUploads: ").append(this.maxUploads()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.uploadIdMarker() != null) {
            sb.append("UploadIdMarker: ").append(this.uploadIdMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String delimiter;
        private String encodingType;
        private String keyMarker;
        private Integer maxUploads;
        private String prefix;
        private String uploadIdMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultipartUploadsRequest model) {
            this.setBucket(model.bucket);
            this.setDelimiter(model.delimiter);
            this.setEncodingType(model.encodingType);
            this.setKeyMarker(model.keyMarker);
            this.setMaxUploads(model.maxUploads);
            this.setPrefix(model.prefix);
            this.setUploadIdMarker(model.uploadIdMarker);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final String getEncodingType() {
            return this.encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final String getKeyMarker() {
            return this.keyMarker;
        }

        @Override
        public final Builder keyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
            return this;
        }

        public final void setKeyMarker(String keyMarker) {
            this.keyMarker = keyMarker;
        }

        public final Integer getMaxUploads() {
            return this.maxUploads;
        }

        @Override
        public final Builder maxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
            return this;
        }

        public final void setMaxUploads(Integer maxUploads) {
            this.maxUploads = maxUploads;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getUploadIdMarker() {
            return this.uploadIdMarker;
        }

        @Override
        public final Builder uploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
            return this;
        }

        public final void setUploadIdMarker(String uploadIdMarker) {
            this.uploadIdMarker = uploadIdMarker;
        }

        public ListMultipartUploadsRequest build() {
            return new ListMultipartUploadsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListMultipartUploadsRequest> {
        public Builder bucket(String var1);

        public Builder delimiter(String var1);

        public Builder encodingType(String var1);

        public Builder encodingType(EncodingType var1);

        public Builder keyMarker(String var1);

        public Builder maxUploads(Integer var1);

        public Builder prefix(String var1);

        public Builder uploadIdMarker(String var1);
    }
}

