/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LifecycleExpiration
implements ToCopyableBuilder<Builder, LifecycleExpiration> {
    private final Instant dateValue;
    private final Integer days;
    private final Boolean expiredObjectDeleteMarker;

    private LifecycleExpiration(BuilderImpl builder) {
        this.dateValue = builder.dateValue;
        this.days = builder.days;
        this.expiredObjectDeleteMarker = builder.expiredObjectDeleteMarker;
    }

    public Instant date() {
        return this.dateValue;
    }

    public Integer days() {
        return this.days;
    }

    public Boolean expiredObjectDeleteMarker() {
        return this.expiredObjectDeleteMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.date() == null ? 0 : this.date().hashCode());
        hashCode = 31 * hashCode + (this.days() == null ? 0 : this.days().hashCode());
        hashCode = 31 * hashCode + (this.expiredObjectDeleteMarker() == null ? 0 : this.expiredObjectDeleteMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleExpiration)) {
            return false;
        }
        LifecycleExpiration other = (LifecycleExpiration)obj;
        if (other.date() == null ^ this.date() == null) {
            return false;
        }
        if (other.date() != null && !other.date().equals(this.date())) {
            return false;
        }
        if (other.days() == null ^ this.days() == null) {
            return false;
        }
        if (other.days() != null && !other.days().equals(this.days())) {
            return false;
        }
        if (other.expiredObjectDeleteMarker() == null ^ this.expiredObjectDeleteMarker() == null) {
            return false;
        }
        return other.expiredObjectDeleteMarker() == null || other.expiredObjectDeleteMarker().equals(this.expiredObjectDeleteMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.date() != null) {
            sb.append("Date: ").append(this.date()).append(",");
        }
        if (this.days() != null) {
            sb.append("Days: ").append(this.days()).append(",");
        }
        if (this.expiredObjectDeleteMarker() != null) {
            sb.append("ExpiredObjectDeleteMarker: ").append(this.expiredObjectDeleteMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant dateValue;
        private Integer days;
        private Boolean expiredObjectDeleteMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleExpiration model) {
            this.setDate(model.dateValue);
            this.setDays(model.days);
            this.setExpiredObjectDeleteMarker(model.expiredObjectDeleteMarker);
        }

        public final Instant getDate() {
            return this.dateValue;
        }

        @Override
        public final Builder date(Instant dateValue) {
            this.dateValue = dateValue;
            return this;
        }

        public final void setDate(Instant dateValue) {
            this.dateValue = dateValue;
        }

        public final Integer getDays() {
            return this.days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final Boolean getExpiredObjectDeleteMarker() {
            return this.expiredObjectDeleteMarker;
        }

        @Override
        public final Builder expiredObjectDeleteMarker(Boolean expiredObjectDeleteMarker) {
            this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
            return this;
        }

        public final void setExpiredObjectDeleteMarker(Boolean expiredObjectDeleteMarker) {
            this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
        }

        public LifecycleExpiration build() {
            return new LifecycleExpiration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LifecycleExpiration> {
        public Builder date(Instant var1);

        public Builder days(Integer var1);

        public Builder expiredObjectDeleteMarker(Boolean var1);
    }
}

