/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.MetadataCopier;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateMultipartUploadRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateMultipartUploadRequest> {
    private final String acl;
    private final String bucket;
    private final String cacheControl;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final String contentType;
    private final Instant expires;
    private final String grantFullControl;
    private final String grantRead;
    private final String grantReadACP;
    private final String grantWriteACP;
    private final String key;
    private final Map<String, String> metadata;
    private final String serverSideEncryption;
    private final String storageClass;
    private final String websiteRedirectLocation;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKey;
    private final String sseCustomerKeyMD5;
    private final String ssekmsKeyId;
    private final String requestPayer;

    private CreateMultipartUploadRequest(BuilderImpl builder) {
        this.acl = builder.acl;
        this.bucket = builder.bucket;
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.contentType = builder.contentType;
        this.expires = builder.expires;
        this.grantFullControl = builder.grantFullControl;
        this.grantRead = builder.grantRead;
        this.grantReadACP = builder.grantReadACP;
        this.grantWriteACP = builder.grantWriteACP;
        this.key = builder.key;
        this.metadata = builder.metadata;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.storageClass = builder.storageClass;
        this.websiteRedirectLocation = builder.websiteRedirectLocation;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.ssekmsKeyId = builder.ssekmsKeyId;
        this.requestPayer = builder.requestPayer;
    }

    public String acl() {
        return this.acl;
    }

    public String bucket() {
        return this.bucket;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String contentType() {
        return this.contentType;
    }

    public Instant expires() {
        return this.expires;
    }

    public String grantFullControl() {
        return this.grantFullControl;
    }

    public String grantRead() {
        return this.grantRead;
    }

    public String grantReadACP() {
        return this.grantReadACP;
    }

    public String grantWriteACP() {
        return this.grantWriteACP;
    }

    public String key() {
        return this.key;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public String serverSideEncryption() {
        return this.serverSideEncryption;
    }

    public String storageClass() {
        return this.storageClass;
    }

    public String websiteRedirectLocation() {
        return this.websiteRedirectLocation;
    }

    public String sseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String sseCustomerKey() {
        return this.sseCustomerKey;
    }

    public String sseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public String ssekmsKeyId() {
        return this.ssekmsKeyId;
    }

    public String requestPayer() {
        return this.requestPayer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acl() == null ? 0 : this.acl().hashCode());
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.cacheControl() == null ? 0 : this.cacheControl().hashCode());
        hashCode = 31 * hashCode + (this.contentDisposition() == null ? 0 : this.contentDisposition().hashCode());
        hashCode = 31 * hashCode + (this.contentEncoding() == null ? 0 : this.contentEncoding().hashCode());
        hashCode = 31 * hashCode + (this.contentLanguage() == null ? 0 : this.contentLanguage().hashCode());
        hashCode = 31 * hashCode + (this.contentType() == null ? 0 : this.contentType().hashCode());
        hashCode = 31 * hashCode + (this.expires() == null ? 0 : this.expires().hashCode());
        hashCode = 31 * hashCode + (this.grantFullControl() == null ? 0 : this.grantFullControl().hashCode());
        hashCode = 31 * hashCode + (this.grantRead() == null ? 0 : this.grantRead().hashCode());
        hashCode = 31 * hashCode + (this.grantReadACP() == null ? 0 : this.grantReadACP().hashCode());
        hashCode = 31 * hashCode + (this.grantWriteACP() == null ? 0 : this.grantWriteACP().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.metadata() == null ? 0 : this.metadata().hashCode());
        hashCode = 31 * hashCode + (this.serverSideEncryption() == null ? 0 : this.serverSideEncryption().hashCode());
        hashCode = 31 * hashCode + (this.storageClass() == null ? 0 : this.storageClass().hashCode());
        hashCode = 31 * hashCode + (this.websiteRedirectLocation() == null ? 0 : this.websiteRedirectLocation().hashCode());
        hashCode = 31 * hashCode + (this.sseCustomerAlgorithm() == null ? 0 : this.sseCustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.sseCustomerKey() == null ? 0 : this.sseCustomerKey().hashCode());
        hashCode = 31 * hashCode + (this.sseCustomerKeyMD5() == null ? 0 : this.sseCustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + (this.ssekmsKeyId() == null ? 0 : this.ssekmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.requestPayer() == null ? 0 : this.requestPayer().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultipartUploadRequest)) {
            return false;
        }
        CreateMultipartUploadRequest other = (CreateMultipartUploadRequest)((Object)obj);
        if (other.acl() == null ^ this.acl() == null) {
            return false;
        }
        if (other.acl() != null && !other.acl().equals(this.acl())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.cacheControl() == null ^ this.cacheControl() == null) {
            return false;
        }
        if (other.cacheControl() != null && !other.cacheControl().equals(this.cacheControl())) {
            return false;
        }
        if (other.contentDisposition() == null ^ this.contentDisposition() == null) {
            return false;
        }
        if (other.contentDisposition() != null && !other.contentDisposition().equals(this.contentDisposition())) {
            return false;
        }
        if (other.contentEncoding() == null ^ this.contentEncoding() == null) {
            return false;
        }
        if (other.contentEncoding() != null && !other.contentEncoding().equals(this.contentEncoding())) {
            return false;
        }
        if (other.contentLanguage() == null ^ this.contentLanguage() == null) {
            return false;
        }
        if (other.contentLanguage() != null && !other.contentLanguage().equals(this.contentLanguage())) {
            return false;
        }
        if (other.contentType() == null ^ this.contentType() == null) {
            return false;
        }
        if (other.contentType() != null && !other.contentType().equals(this.contentType())) {
            return false;
        }
        if (other.expires() == null ^ this.expires() == null) {
            return false;
        }
        if (other.expires() != null && !other.expires().equals(this.expires())) {
            return false;
        }
        if (other.grantFullControl() == null ^ this.grantFullControl() == null) {
            return false;
        }
        if (other.grantFullControl() != null && !other.grantFullControl().equals(this.grantFullControl())) {
            return false;
        }
        if (other.grantRead() == null ^ this.grantRead() == null) {
            return false;
        }
        if (other.grantRead() != null && !other.grantRead().equals(this.grantRead())) {
            return false;
        }
        if (other.grantReadACP() == null ^ this.grantReadACP() == null) {
            return false;
        }
        if (other.grantReadACP() != null && !other.grantReadACP().equals(this.grantReadACP())) {
            return false;
        }
        if (other.grantWriteACP() == null ^ this.grantWriteACP() == null) {
            return false;
        }
        if (other.grantWriteACP() != null && !other.grantWriteACP().equals(this.grantWriteACP())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        if (other.serverSideEncryption() == null ^ this.serverSideEncryption() == null) {
            return false;
        }
        if (other.serverSideEncryption() != null && !other.serverSideEncryption().equals(this.serverSideEncryption())) {
            return false;
        }
        if (other.storageClass() == null ^ this.storageClass() == null) {
            return false;
        }
        if (other.storageClass() != null && !other.storageClass().equals(this.storageClass())) {
            return false;
        }
        if (other.websiteRedirectLocation() == null ^ this.websiteRedirectLocation() == null) {
            return false;
        }
        if (other.websiteRedirectLocation() != null && !other.websiteRedirectLocation().equals(this.websiteRedirectLocation())) {
            return false;
        }
        if (other.sseCustomerAlgorithm() == null ^ this.sseCustomerAlgorithm() == null) {
            return false;
        }
        if (other.sseCustomerAlgorithm() != null && !other.sseCustomerAlgorithm().equals(this.sseCustomerAlgorithm())) {
            return false;
        }
        if (other.sseCustomerKey() == null ^ this.sseCustomerKey() == null) {
            return false;
        }
        if (other.sseCustomerKey() != null && !other.sseCustomerKey().equals(this.sseCustomerKey())) {
            return false;
        }
        if (other.sseCustomerKeyMD5() == null ^ this.sseCustomerKeyMD5() == null) {
            return false;
        }
        if (other.sseCustomerKeyMD5() != null && !other.sseCustomerKeyMD5().equals(this.sseCustomerKeyMD5())) {
            return false;
        }
        if (other.ssekmsKeyId() == null ^ this.ssekmsKeyId() == null) {
            return false;
        }
        if (other.ssekmsKeyId() != null && !other.ssekmsKeyId().equals(this.ssekmsKeyId())) {
            return false;
        }
        if (other.requestPayer() == null ^ this.requestPayer() == null) {
            return false;
        }
        return other.requestPayer() == null || other.requestPayer().equals(this.requestPayer());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acl() != null) {
            sb.append("ACL: ").append(this.acl()).append(",");
        }
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.cacheControl() != null) {
            sb.append("CacheControl: ").append(this.cacheControl()).append(",");
        }
        if (this.contentDisposition() != null) {
            sb.append("ContentDisposition: ").append(this.contentDisposition()).append(",");
        }
        if (this.contentEncoding() != null) {
            sb.append("ContentEncoding: ").append(this.contentEncoding()).append(",");
        }
        if (this.contentLanguage() != null) {
            sb.append("ContentLanguage: ").append(this.contentLanguage()).append(",");
        }
        if (this.contentType() != null) {
            sb.append("ContentType: ").append(this.contentType()).append(",");
        }
        if (this.expires() != null) {
            sb.append("Expires: ").append(this.expires()).append(",");
        }
        if (this.grantFullControl() != null) {
            sb.append("GrantFullControl: ").append(this.grantFullControl()).append(",");
        }
        if (this.grantRead() != null) {
            sb.append("GrantRead: ").append(this.grantRead()).append(",");
        }
        if (this.grantReadACP() != null) {
            sb.append("GrantReadACP: ").append(this.grantReadACP()).append(",");
        }
        if (this.grantWriteACP() != null) {
            sb.append("GrantWriteACP: ").append(this.grantWriteACP()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (this.serverSideEncryption() != null) {
            sb.append("ServerSideEncryption: ").append(this.serverSideEncryption()).append(",");
        }
        if (this.storageClass() != null) {
            sb.append("StorageClass: ").append(this.storageClass()).append(",");
        }
        if (this.websiteRedirectLocation() != null) {
            sb.append("WebsiteRedirectLocation: ").append(this.websiteRedirectLocation()).append(",");
        }
        if (this.sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(this.sseCustomerAlgorithm()).append(",");
        }
        if (this.sseCustomerKey() != null) {
            sb.append("SSECustomerKey: ").append(this.sseCustomerKey()).append(",");
        }
        if (this.sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(this.sseCustomerKeyMD5()).append(",");
        }
        if (this.ssekmsKeyId() != null) {
            sb.append("SSEKMSKeyId: ").append(this.ssekmsKeyId()).append(",");
        }
        if (this.requestPayer() != null) {
            sb.append("RequestPayer: ").append(this.requestPayer()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acl;
        private String bucket;
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private String contentType;
        private Instant expires;
        private String grantFullControl;
        private String grantRead;
        private String grantReadACP;
        private String grantWriteACP;
        private String key;
        private Map<String, String> metadata;
        private String serverSideEncryption;
        private String storageClass;
        private String websiteRedirectLocation;
        private String sseCustomerAlgorithm;
        private String sseCustomerKey;
        private String sseCustomerKeyMD5;
        private String ssekmsKeyId;
        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultipartUploadRequest model) {
            this.setACL(model.acl);
            this.setBucket(model.bucket);
            this.setCacheControl(model.cacheControl);
            this.setContentDisposition(model.contentDisposition);
            this.setContentEncoding(model.contentEncoding);
            this.setContentLanguage(model.contentLanguage);
            this.setContentType(model.contentType);
            this.setExpires(model.expires);
            this.setGrantFullControl(model.grantFullControl);
            this.setGrantRead(model.grantRead);
            this.setGrantReadACP(model.grantReadACP);
            this.setGrantWriteACP(model.grantWriteACP);
            this.setKey(model.key);
            this.setMetadata(model.metadata);
            this.setServerSideEncryption(model.serverSideEncryption);
            this.setStorageClass(model.storageClass);
            this.setWebsiteRedirectLocation(model.websiteRedirectLocation);
            this.setSSECustomerAlgorithm(model.sseCustomerAlgorithm);
            this.setSSECustomerKey(model.sseCustomerKey);
            this.setSSECustomerKeyMD5(model.sseCustomerKeyMD5);
            this.setSSEKMSKeyId(model.ssekmsKeyId);
            this.setRequestPayer(model.requestPayer);
        }

        public final String getACL() {
            return this.acl;
        }

        @Override
        public final Builder acl(String acl) {
            this.acl = acl;
            return this;
        }

        @Override
        public final Builder acl(ObjectCannedACL acl) {
            this.acl(acl.toString());
            return this;
        }

        public final void setACL(String acl) {
            this.acl = acl;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getCacheControl() {
            return this.cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        public final String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public final String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public final void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        public final String getContentLanguage() {
            return this.contentLanguage;
        }

        @Override
        public final Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public final void setContentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Instant getExpires() {
            return this.expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        public final String getGrantFullControl() {
            return this.grantFullControl;
        }

        @Override
        public final Builder grantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
            return this;
        }

        public final void setGrantFullControl(String grantFullControl) {
            this.grantFullControl = grantFullControl;
        }

        public final String getGrantRead() {
            return this.grantRead;
        }

        @Override
        public final Builder grantRead(String grantRead) {
            this.grantRead = grantRead;
            return this;
        }

        public final void setGrantRead(String grantRead) {
            this.grantRead = grantRead;
        }

        public final String getGrantReadACP() {
            return this.grantReadACP;
        }

        @Override
        public final Builder grantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
            return this;
        }

        public final void setGrantReadACP(String grantReadACP) {
            this.grantReadACP = grantReadACP;
        }

        public final String getGrantWriteACP() {
            return this.grantWriteACP;
        }

        @Override
        public final Builder grantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
            return this;
        }

        public final void setGrantWriteACP(String grantWriteACP) {
            this.grantWriteACP = grantWriteACP;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        public final String getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getWebsiteRedirectLocation() {
            return this.websiteRedirectLocation;
        }

        @Override
        public final Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        public final void setWebsiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
        }

        public final String getSSECustomerAlgorithm() {
            return this.sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKey() {
            return this.sseCustomerKey;
        }

        @Override
        public final Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public final void setSSECustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
        }

        public final String getSSECustomerKeyMD5() {
            return this.sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getSSEKMSKeyId() {
            return this.ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSSEKMSKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public CreateMultipartUploadRequest build() {
            return new CreateMultipartUploadRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateMultipartUploadRequest> {
        public Builder acl(String var1);

        public Builder acl(ObjectCannedACL var1);

        public Builder bucket(String var1);

        public Builder cacheControl(String var1);

        public Builder contentDisposition(String var1);

        public Builder contentEncoding(String var1);

        public Builder contentLanguage(String var1);

        public Builder contentType(String var1);

        public Builder expires(Instant var1);

        public Builder grantFullControl(String var1);

        public Builder grantRead(String var1);

        public Builder grantReadACP(String var1);

        public Builder grantWriteACP(String var1);

        public Builder key(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder serverSideEncryption(String var1);

        public Builder serverSideEncryption(ServerSideEncryption var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);

        public Builder websiteRedirectLocation(String var1);

        public Builder sseCustomerAlgorithm(String var1);

        public Builder sseCustomerKey(String var1);

        public Builder sseCustomerKeyMD5(String var1);

        public Builder ssekmsKeyId(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);
    }
}

