/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.handlers;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import software.amazon.awssdk.SdkRequest;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.handlers.AwsExecutionAttributes;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.interceptor.Context;
import software.amazon.awssdk.interceptor.ExecutionAttributes;
import software.amazon.awssdk.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.services.s3.BucketUtils;
import software.amazon.awssdk.services.s3.S3AdvancedConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.utils.FunctionalUtils;

public class EndpointAddressInterceptor
implements ExecutionInterceptor {
    private static List<Class<?>> ACCELERATE_DISABLED_OPERATIONS = Arrays.asList(ListBucketsRequest.class, CreateBucketRequest.class, DeleteBucketRequest.class);

    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        S3AdvancedConfiguration advancedConfiguration = (S3AdvancedConfiguration)executionAttributes.getAttribute(AwsExecutionAttributes.SERVICE_ADVANCED_CONFIG);
        SdkHttpFullRequest.Builder mutableRequest = (SdkHttpFullRequest.Builder)request.toBuilder();
        mutableRequest.endpoint(this.resolveEndpoint(request.getEndpoint(), originalRequest, executionAttributes, advancedConfiguration));
        if (advancedConfiguration == null || !advancedConfiguration.pathStyleAccessEnabled()) {
            try {
                String bucketName = this.getBucketName(originalRequest);
                if (BucketUtils.isValidDnsBucketName(bucketName, false)) {
                    this.changeToDnsEndpoint(mutableRequest, bucketName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (SdkHttpFullRequest)mutableRequest.build();
    }

    private URI resolveEndpoint(URI originalEndpoint, Object originalRequest, ExecutionAttributes executionAttributes, S3AdvancedConfiguration advancedConfiguration) {
        Region region = (Region)executionAttributes.getAttribute(AwsExecutionAttributes.AWS_REGION);
        RegionMetadata regionMetadata = RegionMetadata.of((Region)region);
        if (EndpointAddressInterceptor.isAccelerateEnabled(advancedConfiguration) && this.isAccelerateSupported(originalRequest)) {
            return EndpointAddressInterceptor.accelerateEndpoint(advancedConfiguration, regionMetadata);
        }
        if (advancedConfiguration != null && advancedConfiguration.dualstackEnabled()) {
            return EndpointAddressInterceptor.dualstackEndpoint(regionMetadata);
        }
        return originalEndpoint;
    }

    private static URI dualstackEndpoint(RegionMetadata metadata) {
        String serviceEndpoint = String.format("%s.%s.%s.%s", "s3", "dualstack", metadata.getName(), metadata.getDomain());
        return EndpointAddressInterceptor.toUri(serviceEndpoint);
    }

    private static boolean isAccelerateEnabled(S3AdvancedConfiguration advancedConfiguration) {
        return advancedConfiguration != null && advancedConfiguration.accelerateModeEnabled();
    }

    private boolean isAccelerateSupported(Object originalRequest) {
        return !ACCELERATE_DISABLED_OPERATIONS.contains(originalRequest.getClass());
    }

    private static URI accelerateEndpoint(S3AdvancedConfiguration advancedConfiguration, RegionMetadata metadata) {
        if (advancedConfiguration.dualstackEnabled()) {
            return EndpointAddressInterceptor.toUri("s3-accelerate.dualstack." + metadata.getDomain());
        }
        return EndpointAddressInterceptor.toUri("s3-accelerate." + metadata.getDomain());
    }

    private static URI toUri(String endpoint) throws IllegalArgumentException {
        try {
            return new URI(String.format("%s://%s", "https", endpoint));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @ReviewBeforeRelease(value="Remove reflection here. Have some kind of interface where we can get bucket name or pass itin the handler context")
    private String getBucketName(Object originalRequest) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (String)originalRequest.getClass().getMethod("bucket", new Class[0]).invoke(originalRequest, new Object[0]);
    }

    private void changeToDnsEndpoint(SdkHttpFullRequest.Builder mutableRequest, String bucketName) {
        if (mutableRequest.getEndpoint().getHost().startsWith("s3")) {
            String resourcePath = mutableRequest.getResourcePath().replaceFirst("/" + bucketName, "");
            URI endpoint = (URI)FunctionalUtils.invokeSafely(() -> new URI(mutableRequest.getEndpoint().getScheme(), mutableRequest.getEndpoint().getHost().replaceFirst("s3", bucketName + ".s3"), null, null));
            mutableRequest.endpoint(endpoint);
            mutableRequest.resourcePath(resourcePath);
        }
    }
}

