/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.BucketLoggingStatus;
import software.amazon.awssdk.services.s3.model.Grantee;
import software.amazon.awssdk.services.s3.model.LoggingEnabled;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.TargetGrant;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketLoggingRequestMarshaller
implements Marshaller<Request<PutBucketLoggingRequest>, PutBucketLoggingRequest> {
    public Request<PutBucketLoggingRequest> marshall(PutBucketLoggingRequest putBucketLoggingRequest) {
        if (putBucketLoggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketLoggingRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketLoggingRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString((String)putBucketLoggingRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?logging";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketLoggingRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            BucketLoggingStatus bucketLoggingStatus = putBucketLoggingRequest.bucketLoggingStatus();
            if (bucketLoggingStatus != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("BucketLoggingStatus");
                LoggingEnabled loggingEnabled = bucketLoggingStatus.loggingEnabled();
                if (loggingEnabled != null) {
                    List<TargetGrant> loggingEnabledTargetGrantsList;
                    xmlWriter.startElement("LoggingEnabled");
                    if (loggingEnabled.targetBucket() != null) {
                        xmlWriter.startElement("TargetBucket").value(loggingEnabled.targetBucket()).endElement();
                    }
                    if ((loggingEnabledTargetGrantsList = loggingEnabled.targetGrants()) != null) {
                        xmlWriter.startElement("TargetGrants");
                        for (TargetGrant loggingEnabledTargetGrantsListValue : loggingEnabledTargetGrantsList) {
                            xmlWriter.startElement("Grant");
                            Grantee grantee = loggingEnabledTargetGrantsListValue.grantee();
                            if (grantee != null) {
                                xmlWriter.startElement("Grantee");
                                if (grantee.displayName() != null) {
                                    xmlWriter.startElement("DisplayName").value(grantee.displayName()).endElement();
                                }
                                if (grantee.emailAddress() != null) {
                                    xmlWriter.startElement("EmailAddress").value(grantee.emailAddress()).endElement();
                                }
                                if (grantee.id() != null) {
                                    xmlWriter.startElement("ID").value(grantee.id()).endElement();
                                }
                                if (grantee.type() != null) {
                                    xmlWriter.startElement("xsi:type").value(grantee.type()).endElement();
                                }
                                if (grantee.uri() != null) {
                                    xmlWriter.startElement("URI").value(grantee.uri()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (loggingEnabledTargetGrantsListValue.permission() != null) {
                                xmlWriter.startElement("Permission").value(loggingEnabledTargetGrantsListValue.permission()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (loggingEnabled.targetPrefix() != null) {
                        xmlWriter.startElement("TargetPrefix").value(loggingEnabled.targetPrefix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

