/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload;
import software.amazon.awssdk.services.s3.model.LifecycleConfiguration;
import software.amazon.awssdk.services.s3.model.LifecycleExpiration;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.Rule;
import software.amazon.awssdk.services.s3.model.Transition;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketLifecycleRequestMarshaller
implements Marshaller<Request<PutBucketLifecycleRequest>, PutBucketLifecycleRequest> {
    public Request<PutBucketLifecycleRequest> marshall(PutBucketLifecycleRequest putBucketLifecycleRequest) {
        if (putBucketLifecycleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketLifecycleRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketLifecycleRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString((String)putBucketLifecycleRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?lifecycle";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketLifecycleRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            LifecycleConfiguration lifecycleConfiguration = putBucketLifecycleRequest.lifecycleConfiguration();
            if (lifecycleConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("LifecycleConfiguration");
                List<Rule> lifecycleConfigurationRulesList = lifecycleConfiguration.rules();
                if (lifecycleConfigurationRulesList != null) {
                    for (Rule lifecycleConfigurationRulesListValue : lifecycleConfigurationRulesList) {
                        AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;
                        NoncurrentVersionExpiration noncurrentVersionExpiration;
                        NoncurrentVersionTransition noncurrentVersionTransition;
                        Transition transition;
                        xmlWriter.startElement("Rule");
                        LifecycleExpiration expiration = lifecycleConfigurationRulesListValue.expiration();
                        if (expiration != null) {
                            xmlWriter.startElement("Expiration");
                            if (expiration.date() != null) {
                                xmlWriter.startElement("Date").value((Object)expiration.date()).endElement();
                            }
                            if (expiration.days() != null) {
                                xmlWriter.startElement("Days").value((Object)expiration.days()).endElement();
                            }
                            if (expiration.expiredObjectDeleteMarker() != null) {
                                xmlWriter.startElement("ExpiredObjectDeleteMarker").value((Object)expiration.expiredObjectDeleteMarker()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (lifecycleConfigurationRulesListValue.id() != null) {
                            xmlWriter.startElement("ID").value(lifecycleConfigurationRulesListValue.id()).endElement();
                        }
                        if (lifecycleConfigurationRulesListValue.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(lifecycleConfigurationRulesListValue.prefix()).endElement();
                        }
                        if (lifecycleConfigurationRulesListValue.status() != null) {
                            xmlWriter.startElement("Status").value(lifecycleConfigurationRulesListValue.status()).endElement();
                        }
                        if ((transition = lifecycleConfigurationRulesListValue.transition()) != null) {
                            xmlWriter.startElement("Transition");
                            if (transition.date() != null) {
                                xmlWriter.startElement("Date").value((Object)transition.date()).endElement();
                            }
                            if (transition.days() != null) {
                                xmlWriter.startElement("Days").value((Object)transition.days()).endElement();
                            }
                            if (transition.storageClass() != null) {
                                xmlWriter.startElement("StorageClass").value(transition.storageClass()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((noncurrentVersionTransition = lifecycleConfigurationRulesListValue.noncurrentVersionTransition()) != null) {
                            xmlWriter.startElement("NoncurrentVersionTransition");
                            if (noncurrentVersionTransition.noncurrentDays() != null) {
                                xmlWriter.startElement("NoncurrentDays").value((Object)noncurrentVersionTransition.noncurrentDays()).endElement();
                            }
                            if (noncurrentVersionTransition.storageClass() != null) {
                                xmlWriter.startElement("StorageClass").value(noncurrentVersionTransition.storageClass()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((noncurrentVersionExpiration = lifecycleConfigurationRulesListValue.noncurrentVersionExpiration()) != null) {
                            xmlWriter.startElement("NoncurrentVersionExpiration");
                            if (noncurrentVersionExpiration.noncurrentDays() != null) {
                                xmlWriter.startElement("NoncurrentDays").value((Object)noncurrentVersionExpiration.noncurrentDays()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((abortIncompleteMultipartUpload = lifecycleConfigurationRulesListValue.abortIncompleteMultipartUpload()) != null) {
                            xmlWriter.startElement("AbortIncompleteMultipartUpload");
                            if (abortIncompleteMultipartUpload.daysAfterInitiation() != null) {
                                xmlWriter.startElement("DaysAfterInitiation").value((Object)abortIncompleteMultipartUpload.daysAfterInitiation()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

