/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class ListObjectVersionsRequestMarshaller
implements Marshaller<Request<ListObjectVersionsRequest>, ListObjectVersionsRequest> {
    public Request<ListObjectVersionsRequest> marshall(ListObjectVersionsRequest listObjectVersionsRequest) {
        if (listObjectVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listObjectVersionsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?versions";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", listObjectVersionsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (listObjectVersionsRequest.delimiter() != null) {
            request.addParameter("delimiter", StringUtils.fromString((String)listObjectVersionsRequest.delimiter()));
        }
        if (listObjectVersionsRequest.encodingType() != null) {
            request.addParameter("encoding-type", StringUtils.fromString((String)listObjectVersionsRequest.encodingType()));
        }
        if (listObjectVersionsRequest.keyMarker() != null) {
            request.addParameter("key-marker", StringUtils.fromString((String)listObjectVersionsRequest.keyMarker()));
        }
        if (listObjectVersionsRequest.maxKeys() != null) {
            request.addParameter("max-keys", StringUtils.fromInteger((Integer)listObjectVersionsRequest.maxKeys()));
        }
        if (listObjectVersionsRequest.prefix() != null) {
            request.addParameter("prefix", StringUtils.fromString((String)listObjectVersionsRequest.prefix()));
        }
        if (listObjectVersionsRequest.versionIdMarker() != null) {
            request.addParameter("version-id-marker", StringUtils.fromString((String)listObjectVersionsRequest.versionIdMarker()));
        }
        return request;
    }
}

