/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class ListBucketInventoryConfigurationsRequestMarshaller
implements Marshaller<Request<ListBucketInventoryConfigurationsRequest>, ListBucketInventoryConfigurationsRequest> {
    public Request<ListBucketInventoryConfigurationsRequest> marshall(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) {
        if (listBucketInventoryConfigurationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listBucketInventoryConfigurationsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?inventory";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", listBucketInventoryConfigurationsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (listBucketInventoryConfigurationsRequest.continuationToken() != null) {
            request.addParameter("continuation-token", StringUtils.fromString((String)listBucketInventoryConfigurationsRequest.continuationToken()));
        }
        return request;
    }
}

