/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration;
import software.amazon.awssdk.services.s3.transform.NotificationConfigurationFilterUnmarshaller;

public class LambdaFunctionConfigurationUnmarshaller
implements Unmarshaller<LambdaFunctionConfiguration, StaxUnmarshallerContext> {
    private static LambdaFunctionConfigurationUnmarshaller INSTANCE;

    public LambdaFunctionConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        LambdaFunctionConfiguration.Builder lambdaFunctionConfiguration;
        block8: {
            lambdaFunctionConfiguration = LambdaFunctionConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> events = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    lambdaFunctionConfiguration.events(events);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Id", targetDepth)) {
                        lambdaFunctionConfiguration.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CloudFunction", targetDepth)) {
                        lambdaFunctionConfiguration.lambdaFunctionArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Event", targetDepth)) {
                        if (events == null) {
                            events = new ArrayList<String>();
                        }
                        events.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Filter", targetDepth)) continue;
                    lambdaFunctionConfiguration.filter(NotificationConfigurationFilterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            lambdaFunctionConfiguration.events(events);
        }
        return (LambdaFunctionConfiguration)lambdaFunctionConfiguration.build();
    }

    public static LambdaFunctionConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LambdaFunctionConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

