/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class GetObjectTorrentRequestMarshaller
implements Marshaller<Request<GetObjectTorrentRequest>, GetObjectTorrentRequest> {
    public Request<GetObjectTorrentRequest> marshall(GetObjectTorrentRequest getObjectTorrentRequest) {
        if (getObjectTorrentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getObjectTorrentRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (getObjectTorrentRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)getObjectTorrentRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}?torrent";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", getObjectTorrentRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", getObjectTorrentRequest.key());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

