/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CloudFunctionConfiguration;

public class CloudFunctionConfigurationUnmarshaller
implements Unmarshaller<CloudFunctionConfiguration, StaxUnmarshallerContext> {
    private static CloudFunctionConfigurationUnmarshaller INSTANCE;

    public CloudFunctionConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        CloudFunctionConfiguration.Builder cloudFunctionConfiguration;
        block9: {
            cloudFunctionConfiguration = CloudFunctionConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> events = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    cloudFunctionConfiguration.events(events);
                    break block9;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Id", targetDepth)) {
                        cloudFunctionConfiguration.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Event", targetDepth)) {
                        cloudFunctionConfiguration.event(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Event", targetDepth)) {
                        if (events == null) {
                            events = new ArrayList<String>();
                        }
                        events.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CloudFunction", targetDepth)) {
                        cloudFunctionConfiguration.cloudFunction(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("InvocationRole", targetDepth)) continue;
                    cloudFunctionConfiguration.invocationRole(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            cloudFunctionConfiguration.events(events);
        }
        return (CloudFunctionConfiguration)cloudFunctionConfiguration.build();
    }

    public static CloudFunctionConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CloudFunctionConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

