/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.util.StringUtils;

public class AbortMultipartUploadRequestMarshaller
implements Marshaller<Request<AbortMultipartUploadRequest>, AbortMultipartUploadRequest> {
    public Request<AbortMultipartUploadRequest> marshall(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        if (abortMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)abortMultipartUploadRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (abortMultipartUploadRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)abortMultipartUploadRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", abortMultipartUploadRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", abortMultipartUploadRequest.key());
        request.setResourcePath(uriResourcePath);
        if (abortMultipartUploadRequest.uploadId() != null) {
            request.addParameter("uploadId", StringUtils.fromString((String)abortMultipartUploadRequest.uploadId()));
        }
        return request;
    }
}

