/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import software.amazon.awssdk.services.s3.model.ObjectVersionStorageClass;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ObjectVersion
implements ToCopyableBuilder<Builder, ObjectVersion> {
    private final String eTag;
    private final Integer size;
    private final String storageClass;
    private final String key;
    private final String versionId;
    private final Boolean isLatest;
    private final Instant lastModified;
    private final Owner owner;

    private ObjectVersion(BuilderImpl builder) {
        this.eTag = builder.eTag;
        this.size = builder.size;
        this.storageClass = builder.storageClass;
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.isLatest = builder.isLatest;
        this.lastModified = builder.lastModified;
        this.owner = builder.owner;
    }

    public String eTag() {
        return this.eTag;
    }

    public Integer size() {
        return this.size;
    }

    public String storageClass() {
        return this.storageClass;
    }

    public String key() {
        return this.key;
    }

    public String versionId() {
        return this.versionId;
    }

    public Boolean isLatest() {
        return this.isLatest;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public Owner owner() {
        return this.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eTag() == null ? 0 : this.eTag().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        hashCode = 31 * hashCode + (this.storageClass() == null ? 0 : this.storageClass().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.versionId() == null ? 0 : this.versionId().hashCode());
        hashCode = 31 * hashCode + (this.isLatest() == null ? 0 : this.isLatest().hashCode());
        hashCode = 31 * hashCode + (this.lastModified() == null ? 0 : this.lastModified().hashCode());
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectVersion)) {
            return false;
        }
        ObjectVersion other = (ObjectVersion)obj;
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.storageClass() == null ^ this.storageClass() == null) {
            return false;
        }
        if (other.storageClass() != null && !other.storageClass().equals(this.storageClass())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.isLatest() == null ^ this.isLatest() == null) {
            return false;
        }
        if (other.isLatest() != null && !other.isLatest().equals(this.isLatest())) {
            return false;
        }
        if (other.lastModified() == null ^ this.lastModified() == null) {
            return false;
        }
        if (other.lastModified() != null && !other.lastModified().equals(this.lastModified())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        return other.owner() == null || other.owner().equals(this.owner());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eTag() != null) {
            sb.append("ETag: ").append(this.eTag()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (this.storageClass() != null) {
            sb.append("StorageClass: ").append(this.storageClass()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.isLatest() != null) {
            sb.append("IsLatest: ").append(this.isLatest()).append(",");
        }
        if (this.lastModified() != null) {
            sb.append("LastModified: ").append(this.lastModified()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String eTag;
        private Integer size;
        private String storageClass;
        private String key;
        private String versionId;
        private Boolean isLatest;
        private Instant lastModified;
        private Owner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectVersion model) {
            this.setETag(model.eTag);
            this.setSize(model.size);
            this.setStorageClass(model.storageClass);
            this.setKey(model.key);
            this.setVersionId(model.versionId);
            this.setIsLatest(model.isLatest);
            this.setLastModified(model.lastModified);
            this.setOwner(model.owner);
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(ObjectVersionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final void setStorageClass(ObjectVersionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getIsLatest() {
            return this.isLatest;
        }

        @Override
        public final Builder isLatest(Boolean isLatest) {
            this.isLatest = isLatest;
            return this;
        }

        public final void setIsLatest(Boolean isLatest) {
            this.isLatest = isLatest;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Owner getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner owner) {
            this.owner = owner;
        }

        public ObjectVersion build() {
            return new ObjectVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ObjectVersion> {
        public Builder eTag(String var1);

        public Builder size(Integer var1);

        public Builder storageClass(String var1);

        public Builder storageClass(ObjectVersionStorageClass var1);

        public Builder key(String var1);

        public Builder versionId(String var1);

        public Builder isLatest(Boolean var1);

        public Builder lastModified(Instant var1);

        public Builder owner(Owner var1);
    }
}

