/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.Initiator;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.Part;
import software.amazon.awssdk.services.s3.model.PartsCopier;
import software.amazon.awssdk.services.s3.model.RequestCharged;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPartsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPartsResponse> {
    private final Instant abortDate;
    private final String abortRuleId;
    private final String bucket;
    private final String key;
    private final String uploadId;
    private final Integer partNumberMarker;
    private final Integer nextPartNumberMarker;
    private final Integer maxParts;
    private final Boolean isTruncated;
    private final List<Part> parts;
    private final Initiator initiator;
    private final Owner owner;
    private final String storageClass;
    private final String requestCharged;

    private ListPartsResponse(BuilderImpl builder) {
        this.abortDate = builder.abortDate;
        this.abortRuleId = builder.abortRuleId;
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.uploadId = builder.uploadId;
        this.partNumberMarker = builder.partNumberMarker;
        this.nextPartNumberMarker = builder.nextPartNumberMarker;
        this.maxParts = builder.maxParts;
        this.isTruncated = builder.isTruncated;
        this.parts = builder.parts;
        this.initiator = builder.initiator;
        this.owner = builder.owner;
        this.storageClass = builder.storageClass;
        this.requestCharged = builder.requestCharged;
    }

    public Instant abortDate() {
        return this.abortDate;
    }

    public String abortRuleId() {
        return this.abortRuleId;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public Integer partNumberMarker() {
        return this.partNumberMarker;
    }

    public Integer nextPartNumberMarker() {
        return this.nextPartNumberMarker;
    }

    public Integer maxParts() {
        return this.maxParts;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public List<Part> parts() {
        return this.parts;
    }

    public Initiator initiator() {
        return this.initiator;
    }

    public Owner owner() {
        return this.owner;
    }

    public String storageClass() {
        return this.storageClass;
    }

    public String requestCharged() {
        return this.requestCharged;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.abortDate() == null ? 0 : this.abortDate().hashCode());
        hashCode = 31 * hashCode + (this.abortRuleId() == null ? 0 : this.abortRuleId().hashCode());
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.uploadId() == null ? 0 : this.uploadId().hashCode());
        hashCode = 31 * hashCode + (this.partNumberMarker() == null ? 0 : this.partNumberMarker().hashCode());
        hashCode = 31 * hashCode + (this.nextPartNumberMarker() == null ? 0 : this.nextPartNumberMarker().hashCode());
        hashCode = 31 * hashCode + (this.maxParts() == null ? 0 : this.maxParts().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.parts() == null ? 0 : this.parts().hashCode());
        hashCode = 31 * hashCode + (this.initiator() == null ? 0 : this.initiator().hashCode());
        hashCode = 31 * hashCode + (this.owner() == null ? 0 : this.owner().hashCode());
        hashCode = 31 * hashCode + (this.storageClass() == null ? 0 : this.storageClass().hashCode());
        hashCode = 31 * hashCode + (this.requestCharged() == null ? 0 : this.requestCharged().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartsResponse)) {
            return false;
        }
        ListPartsResponse other = (ListPartsResponse)((Object)obj);
        if (other.abortDate() == null ^ this.abortDate() == null) {
            return false;
        }
        if (other.abortDate() != null && !other.abortDate().equals(this.abortDate())) {
            return false;
        }
        if (other.abortRuleId() == null ^ this.abortRuleId() == null) {
            return false;
        }
        if (other.abortRuleId() != null && !other.abortRuleId().equals(this.abortRuleId())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.partNumberMarker() == null ^ this.partNumberMarker() == null) {
            return false;
        }
        if (other.partNumberMarker() != null && !other.partNumberMarker().equals(this.partNumberMarker())) {
            return false;
        }
        if (other.nextPartNumberMarker() == null ^ this.nextPartNumberMarker() == null) {
            return false;
        }
        if (other.nextPartNumberMarker() != null && !other.nextPartNumberMarker().equals(this.nextPartNumberMarker())) {
            return false;
        }
        if (other.maxParts() == null ^ this.maxParts() == null) {
            return false;
        }
        if (other.maxParts() != null && !other.maxParts().equals(this.maxParts())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.parts() == null ^ this.parts() == null) {
            return false;
        }
        if (other.parts() != null && !other.parts().equals(this.parts())) {
            return false;
        }
        if (other.initiator() == null ^ this.initiator() == null) {
            return false;
        }
        if (other.initiator() != null && !other.initiator().equals(this.initiator())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.storageClass() == null ^ this.storageClass() == null) {
            return false;
        }
        if (other.storageClass() != null && !other.storageClass().equals(this.storageClass())) {
            return false;
        }
        if (other.requestCharged() == null ^ this.requestCharged() == null) {
            return false;
        }
        return other.requestCharged() == null || other.requestCharged().equals(this.requestCharged());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.abortDate() != null) {
            sb.append("AbortDate: ").append(this.abortDate()).append(",");
        }
        if (this.abortRuleId() != null) {
            sb.append("AbortRuleId: ").append(this.abortRuleId()).append(",");
        }
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (this.partNumberMarker() != null) {
            sb.append("PartNumberMarker: ").append(this.partNumberMarker()).append(",");
        }
        if (this.nextPartNumberMarker() != null) {
            sb.append("NextPartNumberMarker: ").append(this.nextPartNumberMarker()).append(",");
        }
        if (this.maxParts() != null) {
            sb.append("MaxParts: ").append(this.maxParts()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.parts() != null) {
            sb.append("Parts: ").append(this.parts()).append(",");
        }
        if (this.initiator() != null) {
            sb.append("Initiator: ").append(this.initiator()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.storageClass() != null) {
            sb.append("StorageClass: ").append(this.storageClass()).append(",");
        }
        if (this.requestCharged() != null) {
            sb.append("RequestCharged: ").append(this.requestCharged()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant abortDate;
        private String abortRuleId;
        private String bucket;
        private String key;
        private String uploadId;
        private Integer partNumberMarker;
        private Integer nextPartNumberMarker;
        private Integer maxParts;
        private Boolean isTruncated;
        private List<Part> parts;
        private Initiator initiator;
        private Owner owner;
        private String storageClass;
        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartsResponse model) {
            this.setAbortDate(model.abortDate);
            this.setAbortRuleId(model.abortRuleId);
            this.setBucket(model.bucket);
            this.setKey(model.key);
            this.setUploadId(model.uploadId);
            this.setPartNumberMarker(model.partNumberMarker);
            this.setNextPartNumberMarker(model.nextPartNumberMarker);
            this.setMaxParts(model.maxParts);
            this.setIsTruncated(model.isTruncated);
            this.setParts(model.parts);
            this.setInitiator(model.initiator);
            this.setOwner(model.owner);
            this.setStorageClass(model.storageClass);
            this.setRequestCharged(model.requestCharged);
        }

        public final Instant getAbortDate() {
            return this.abortDate;
        }

        @Override
        public final Builder abortDate(Instant abortDate) {
            this.abortDate = abortDate;
            return this;
        }

        public final void setAbortDate(Instant abortDate) {
            this.abortDate = abortDate;
        }

        public final String getAbortRuleId() {
            return this.abortRuleId;
        }

        @Override
        public final Builder abortRuleId(String abortRuleId) {
            this.abortRuleId = abortRuleId;
            return this;
        }

        public final void setAbortRuleId(String abortRuleId) {
            this.abortRuleId = abortRuleId;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Integer getPartNumberMarker() {
            return this.partNumberMarker;
        }

        @Override
        public final Builder partNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        public final void setPartNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
        }

        public final Integer getNextPartNumberMarker() {
            return this.nextPartNumberMarker;
        }

        @Override
        public final Builder nextPartNumberMarker(Integer nextPartNumberMarker) {
            this.nextPartNumberMarker = nextPartNumberMarker;
            return this;
        }

        public final void setNextPartNumberMarker(Integer nextPartNumberMarker) {
            this.nextPartNumberMarker = nextPartNumberMarker;
        }

        public final Integer getMaxParts() {
            return this.maxParts;
        }

        @Override
        public final Builder maxParts(Integer maxParts) {
            this.maxParts = maxParts;
            return this;
        }

        public final void setMaxParts(Integer maxParts) {
            this.maxParts = maxParts;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Collection<Part> getParts() {
            return this.parts;
        }

        @Override
        public final Builder parts(Collection<Part> parts) {
            this.parts = PartsCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(Part ... parts) {
            this.parts(Arrays.asList(parts));
            return this;
        }

        public final void setParts(Collection<Part> parts) {
            this.parts = PartsCopier.copy(parts);
        }

        @SafeVarargs
        public final void setParts(Part ... parts) {
            this.parts(Arrays.asList(parts));
        }

        public final Initiator getInitiator() {
            return this.initiator;
        }

        @Override
        public final Builder initiator(Initiator initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(Initiator initiator) {
            this.initiator = initiator;
        }

        public final Owner getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner owner) {
            this.owner = owner;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final void setStorageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
        }

        public final String getRequestCharged() {
            return this.requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public final void setRequestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
        }

        public ListPartsResponse build() {
            return new ListPartsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPartsResponse> {
        public Builder abortDate(Instant var1);

        public Builder abortRuleId(String var1);

        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder uploadId(String var1);

        public Builder partNumberMarker(Integer var1);

        public Builder nextPartNumberMarker(Integer var1);

        public Builder maxParts(Integer var1);

        public Builder isTruncated(Boolean var1);

        public Builder parts(Collection<Part> var1);

        public Builder parts(Part ... var1);

        public Builder initiator(Initiator var1);

        public Builder owner(Owner var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);

        public Builder requestCharged(String var1);

        public Builder requestCharged(RequestCharged var1);
    }
}

