/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.Event;
import software.amazon.awssdk.services.s3.model.EventListCopier;
import software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LambdaFunctionConfiguration
implements ToCopyableBuilder<Builder, LambdaFunctionConfiguration> {
    private final String id;
    private final String lambdaFunctionArn;
    private final List<String> events;
    private final NotificationConfigurationFilter filter;

    private LambdaFunctionConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
        this.events = builder.events;
        this.filter = builder.filter;
    }

    public String id() {
        return this.id;
    }

    public String lambdaFunctionArn() {
        return this.lambdaFunctionArn;
    }

    public List<String> events() {
        return this.events;
    }

    public NotificationConfigurationFilter filter() {
        return this.filter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.lambdaFunctionArn() == null ? 0 : this.lambdaFunctionArn().hashCode());
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionConfiguration)) {
            return false;
        }
        LambdaFunctionConfiguration other = (LambdaFunctionConfiguration)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.lambdaFunctionArn() == null ^ this.lambdaFunctionArn() == null) {
            return false;
        }
        if (other.lambdaFunctionArn() != null && !other.lambdaFunctionArn().equals(this.lambdaFunctionArn())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        return other.filter() == null || other.filter().equals(this.filter());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.lambdaFunctionArn() != null) {
            sb.append("LambdaFunctionArn: ").append(this.lambdaFunctionArn()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String lambdaFunctionArn;
        private List<String> events;
        private NotificationConfigurationFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionConfiguration model) {
            this.setId(model.id);
            this.setLambdaFunctionArn(model.lambdaFunctionArn);
            this.setEvents(model.events);
            this.setFilter(model.filter);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getLambdaFunctionArn() {
            return this.lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event ... events) {
            this.events(Arrays.asList(events).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(String ... events) {
            this.events(Arrays.asList(events));
        }

        @SafeVarargs
        public final void setEvents(Event ... events) {
            this.events(Arrays.asList(events).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public final NotificationConfigurationFilter getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(NotificationConfigurationFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(NotificationConfigurationFilter filter) {
            this.filter = filter;
        }

        public LambdaFunctionConfiguration build() {
            return new LambdaFunctionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LambdaFunctionConfiguration> {
        public Builder id(String var1);

        public Builder lambdaFunctionArn(String var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);

        public Builder events(Event ... var1);

        public Builder filter(NotificationConfigurationFilter var1);
    }
}

