/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.ObjectIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Delete
implements ToCopyableBuilder<Builder, Delete> {
    private final List<ObjectIdentifier> objects;
    private final Boolean quiet;

    private Delete(BuilderImpl builder) {
        this.objects = builder.objects;
        this.quiet = builder.quiet;
    }

    public List<ObjectIdentifier> objects() {
        return this.objects;
    }

    public Boolean quiet() {
        return this.quiet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.objects() == null ? 0 : this.objects().hashCode());
        hashCode = 31 * hashCode + (this.quiet() == null ? 0 : this.quiet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Delete)) {
            return false;
        }
        Delete other = (Delete)obj;
        if (other.objects() == null ^ this.objects() == null) {
            return false;
        }
        if (other.objects() != null && !other.objects().equals(this.objects())) {
            return false;
        }
        if (other.quiet() == null ^ this.quiet() == null) {
            return false;
        }
        return other.quiet() == null || other.quiet().equals(this.quiet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.objects() != null) {
            sb.append("Objects: ").append(this.objects()).append(",");
        }
        if (this.quiet() != null) {
            sb.append("Quiet: ").append(this.quiet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ObjectIdentifier> objects;
        private Boolean quiet;

        private BuilderImpl() {
        }

        private BuilderImpl(Delete model) {
            this.setObjects(model.objects);
            this.setQuiet(model.quiet);
        }

        public final Collection<ObjectIdentifier> getObjects() {
            return this.objects;
        }

        @Override
        public final Builder objects(Collection<ObjectIdentifier> objects) {
            this.objects = ObjectIdentifierListCopier.copy(objects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(ObjectIdentifier ... objects) {
            this.objects(Arrays.asList(objects));
            return this;
        }

        public final void setObjects(Collection<ObjectIdentifier> objects) {
            this.objects = ObjectIdentifierListCopier.copy(objects);
        }

        @SafeVarargs
        public final void setObjects(ObjectIdentifier ... objects) {
            this.objects(Arrays.asList(objects));
        }

        public final Boolean getQuiet() {
            return this.quiet;
        }

        @Override
        public final Builder quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public final void setQuiet(Boolean quiet) {
            this.quiet = quiet;
        }

        public Delete build() {
            return new Delete(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Delete> {
        public Builder objects(Collection<ObjectIdentifier> var1);

        public Builder objects(ObjectIdentifier ... var1);

        public Builder quiet(Boolean var1);
    }
}

