/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyObjectResult
implements ToCopyableBuilder<Builder, CopyObjectResult> {
    private final String eTag;
    private final Instant lastModified;

    private CopyObjectResult(BuilderImpl builder) {
        this.eTag = builder.eTag;
        this.lastModified = builder.lastModified;
    }

    public String eTag() {
        return this.eTag;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eTag() == null ? 0 : this.eTag().hashCode());
        hashCode = 31 * hashCode + (this.lastModified() == null ? 0 : this.lastModified().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyObjectResult)) {
            return false;
        }
        CopyObjectResult other = (CopyObjectResult)obj;
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        if (other.eTag() != null && !other.eTag().equals(this.eTag())) {
            return false;
        }
        if (other.lastModified() == null ^ this.lastModified() == null) {
            return false;
        }
        return other.lastModified() == null || other.lastModified().equals(this.lastModified());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.eTag() != null) {
            sb.append("ETag: ").append(this.eTag()).append(",");
        }
        if (this.lastModified() != null) {
            sb.append("LastModified: ").append(this.lastModified()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String eTag;
        private Instant lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyObjectResult model) {
            this.setETag(model.eTag);
            this.setLastModified(model.lastModified);
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public CopyObjectResult build() {
            return new CopyObjectResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CopyObjectResult> {
        public Builder eTag(String var1);

        public Builder lastModified(Instant var1);
    }
}

