/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompleteMultipartUploadRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CompleteMultipartUploadRequest> {
    private final String bucket;
    private final String key;
    private final CompletedMultipartUpload multipartUpload;
    private final String uploadId;
    private final String requestPayer;

    private CompleteMultipartUploadRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.multipartUpload = builder.multipartUpload;
        this.uploadId = builder.uploadId;
        this.requestPayer = builder.requestPayer;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public CompletedMultipartUpload multipartUpload() {
        return this.multipartUpload;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String requestPayer() {
        return this.requestPayer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.multipartUpload() == null ? 0 : this.multipartUpload().hashCode());
        hashCode = 31 * hashCode + (this.uploadId() == null ? 0 : this.uploadId().hashCode());
        hashCode = 31 * hashCode + (this.requestPayer() == null ? 0 : this.requestPayer().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteMultipartUploadRequest)) {
            return false;
        }
        CompleteMultipartUploadRequest other = (CompleteMultipartUploadRequest)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.multipartUpload() == null ^ this.multipartUpload() == null) {
            return false;
        }
        if (other.multipartUpload() != null && !other.multipartUpload().equals(this.multipartUpload())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.requestPayer() == null ^ this.requestPayer() == null) {
            return false;
        }
        return other.requestPayer() == null || other.requestPayer().equals(this.requestPayer());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.multipartUpload() != null) {
            sb.append("MultipartUpload: ").append(this.multipartUpload()).append(",");
        }
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (this.requestPayer() != null) {
            sb.append("RequestPayer: ").append(this.requestPayer()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String key;
        private CompletedMultipartUpload multipartUpload;
        private String uploadId;
        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteMultipartUploadRequest model) {
            this.setBucket(model.bucket);
            this.setKey(model.key);
            this.setMultipartUpload(model.multipartUpload);
            this.setUploadId(model.uploadId);
            this.setRequestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final CompletedMultipartUpload getMultipartUpload() {
            return this.multipartUpload;
        }

        @Override
        public final Builder multipartUpload(CompletedMultipartUpload multipartUpload) {
            this.multipartUpload = multipartUpload;
            return this;
        }

        public final void setMultipartUpload(CompletedMultipartUpload multipartUpload) {
            this.multipartUpload = multipartUpload;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final void setRequestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
        }

        public CompleteMultipartUploadRequest build() {
            return new CompleteMultipartUploadRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompleteMultipartUploadRequest> {
        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder multipartUpload(CompletedMultipartUpload var1);

        public Builder uploadId(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);
    }
}

