/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.handlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;

public final class SingleStringResponseHandler
extends RequestHandler {
    @ReviewBeforeRelease(value="Change to use instanceof on request object after request handlers refactor")
    public HttpResponse beforeUnmarshalling(SdkHttpFullRequest request, HttpResponse httpResponse) {
        if (request.getHttpMethod().equals((Object)SdkHttpMethod.GET) && httpResponse.getContent() != null) {
            if (request.getParameters().containsKey("policy")) {
                this.addPolicyXmlTags(httpResponse);
            } else if (request.getParameters().containsKey("location")) {
                this.wrapLocationConstraintResponseToExpectedDepth(httpResponse);
            }
        }
        return httpResponse;
    }

    private void addPolicyXmlTags(HttpResponse httpResponse) {
        List<InputStream> streams = Arrays.asList(new ByteArrayInputStream("<Policy>".getBytes(StandardCharsets.UTF_8)), httpResponse.getContent(), new ByteArrayInputStream("</Policy>".getBytes(StandardCharsets.UTF_8)));
        httpResponse.setContent((InputStream)new SequenceInputStream(Collections.enumeration(streams)));
    }

    private void wrapLocationConstraintResponseToExpectedDepth(HttpResponse httpResponse) {
        String contents = (String)FunctionalUtils.invokeSafely(() -> IoUtils.toString((InputStream)httpResponse.getContent()));
        String newContents = contents.replace("<LocationConstraint", "<Wrap><LocationConstraint").replace("</LocationConstraint>", "</LocationConstraint></Wrap>");
        httpResponse.setContent((InputStream)new ByteArrayInputStream(newContents.getBytes(StandardCharsets.UTF_8)));
    }
}

